﻿using static System.Console;
using static System.IO.Path;
using static System.Environment;
using Biblioteka;
using System.Xml;

TytulSekcji("Praca ze strumieniami tekstowymi");

// definiuje plik, z którym będziemy pracować
string plikTekstowy = Combine(CurrentDirectory, "strumienie.txt");

// tworzenie pliku tekstowego zwraca klasę pomocniczą
StreamWriter tekst = File.CreateText(plikTekstowy);

// przejdź w pętli wszystkie wywołania i wypisz je
// w pliku, każde w osobnym wierszu
foreach (string wywolanie in Viper.wywolania)
{
   tekst.WriteLine(wywolanie);
}
tekst.Close(); // zwolnij zasoby

WypiszInfoOPliku(plikTekstowy);



TytulSekcji("Praca ze strumieniami XML");

// definiowanie pliku, do którego będziemy zapisywać
string plikXml = Combine(CurrentDirectory, "strumienie.xml");

// deklarowanie zmiennych do pracy ze strumieniem
FileStream? strumienPlikuXml = null;
XmlWriter? xml = null;

try
{
   // utworzenia strumienia do pliku
   strumienPlikuXml = File.Create(plikXml);

   // opakowanie strumienia do pliku w klasie zapisującej
   // format XML i włączenie automatycznych wcięć
   xml = XmlWriter.Create(strumienPlikuXml,
     new XmlWriterSettings { Indent = true });

   // zapisanie deklaracji XML
   xml.WriteStartDocument();

   // zapisanie elementu bazowego
   xml.WriteStartElement("wywolania");

   // wypisywanie w pętli wszystkich wywołań z tablicy
   foreach (string wywolanie in Viper.wywolania)
   {
      xml.WriteElementString("wywolanie", wywolanie);
   }

   // zapisanie zamknięcia elementu bazowego
   xml.WriteEndElement();
}
catch (Exception ex)
{
   // jeżeli ścieżka nie istnieje, to przechwycimy tu wyjątek
   WriteLine($"{ex.GetType()} z komunikatem {ex.Message}");
}
finally
{
   if (xml is not null)
   {
      xml.Close();
      WriteLine("Niezarządzane zasoby obiektu zapisującego XML zostały zwolnione.");
   }

   if (strumienPlikuXml != null)
   {
      strumienPlikuXml.Close();
      WriteLine("Niezarządzane zasoby strumienia do pliku zostały zwolnione.");
   }
}

WypiszInfoOPliku(plikXml);




TytulSekcji("Strumienie kompresujące");
Kompresuj(algorytm: "gzip");
Kompresuj(algorytm: "brotli");
