﻿using Biblioteka;  // Klasa Viper.
using System.IO.Compression;  // BrotliStream, GZipStream, CompressionMode
using System.Xml; // XmlWriter, XmlReader

partial class Program
{
   static void Kompresuj(string algorytm = "gzip")
   {
      // definiowanie nazwy pliku, w którym rozszerzenie jest nazwą algorytmu
      string sciezkaDoPliku = Combine(
        CurrentDirectory, $"strumienie.{algorytm}");

      FileStream plik = File.Create(sciezkaDoPliku);
      Stream kompresor;
      if (algorytm == "gzip")
      {
         kompresor = new GZipStream(plik, CompressionMode.Compress);
      }
      else
      {
         kompresor = new BrotliStream(plik, CompressionMode.Compress);
      }

      using (kompresor)
      {
         using (XmlWriter xml = XmlWriter.Create(kompresor))
         {
            xml.WriteStartDocument();
            xml.WriteStartElement("wywolania");
            foreach (string wywolanie in Viper.wywolania)
            {
               xml.WriteElementString("wywolanie", wywolanie);
            }
         }
      } // zamyka też podstawowy strumień

      WypiszInfoOPliku(sciezkaDoPliku);

      // odczytanie skompresowanego pliku
      WriteLine("Odczytuję skompresowany plik XML:");
      plik = File.Open(sciezkaDoPliku, FileMode.Open);
      Stream dekompresor;
      if (algorytm == "gzip")
      {
         dekompresor = new GZipStream(plik, CompressionMode.Decompress);
      }
      else
      {
         dekompresor = new BrotliStream(plik, CompressionMode.Decompress);
      }

      using (dekompresor)
      {
         using (XmlReader odczyt = XmlReader.Create(dekompresor))
         {
            while (odczyt.Read())
            {
               // sprawdzenie, czy aktualnie jesteśmy w węźle o nazwie 'wywolanie'
               if ((odczyt.NodeType == XmlNodeType.Element)
                 && (odczyt.Name == "wywolanie"))
               {
                  odczyt.Read(); // przejście do węzła tekstowego w ramach elementu
                  WriteLine($"{odczyt.Value}"); // odczytanie wartości węzła
               }
            }
         }
      }
   }
}
