using Microsoft.EntityFrameworkCore; // dołącza metodę rozszerzającą
using BibliotekaWspolna; // Northwind, Category, Product

partial class Program
{
   static void ZapytanieOKategorie()
   {
      using (Northwind db = new())
      {
         TytulSekcji("Lista kategorii i liczba przypisanych im produktów:");

         // zapytanie pobiera wszystkie kategorie i związane z nimi produkty
         IQueryable<Category>? kategorie = db.Categories?
            .Include(c => c.Products);

         if ((kategorie is null) || (!kategorie.Any()))
         {
            Blad("Nie znaleziono żadnych kategorii.");
            return;
         }
         // wykonaj zapytanie i przejrzyj wyniki
         foreach (Category k in kategorie)
         {
            WriteLine($"Kategoria {k.CategoryName} ma {k.Products.Count} produktów.");
         }
      }
   }
   
   
   static void FiltrowanieDolaczen()
	{
	  using (Northwind db = new())
	  {
		TytulSekcji("Produkty z minimalną liczbą sztuk w magazynie");

		string? wejscie;
		int sztukWMagazynie;

		do
		{
		  Write("Podaj minimalną liczbę sztuk w magazynie: ");
		  wejscie = ReadLine();
		} while (!int.TryParse(wejcie, out sztukWMagazynie));

		IQueryable<Category>? kategorie = db.Categories?
		  .Include(c => c.Products.Where(p => p.Stock >= sztuki));

		if (kategorie is null)
		{
		  Blad("Nie znaleziono kategorii.");
		  return;
		}

		Info($"ToQueryString: {kategorie.ToQueryString()}");
		foreach (Category k in kategorie)
		{
		  WriteLine($"Kategoria {k.CategoryName} ma {k.Products.Count} produktów z przynajmniej {sztuki} sztukami w magazynie.");

		  foreach(Product p in c.Products)
		  {
			WriteLine($" Produkt {p.ProductName}: {p.Stock} sztuk");
		  }
		}
	  }
	}


	static void ZapytanieOProdukty()
	{
	   using (Northwind db = new())
	   {
		  TytulSekcji("Produkty kosztujące więcej niż podana cena; posortowane malejąco:");

		  string? wejscie;
		  decimal cena;

		  do
		  {
			 Write("Podaj cenę produktu: ");
			 wejscie = ReadLine();
		  } while (!decimal.TryParse(wejscie, out cena));

		  IQueryable<Product>? produkty = db.Products?
			.Where(produkt => produkt.Koszt > cena)
			.OrderByDescending(produkt => produkt.Koszt);

		  if ((produkty is null) || (!produkty.Any()))
		  {
			Blad("Nie znaleziono produktów.");
			return;
		  }

		  Info($"ToQueryString: {produkty.ToQueryString()}");
		  foreach (Product produkt in produkty)
		  {
			 WriteLine($"{0}: {1} kosztuje {2:$#,##0.00}. W magazynie jest {3} sztuk.",
			   produkt.ProductID, produkt.ProductName, produkt.Cost, produkt.Stock);
		  }
	   }
	}


	static void ZapytanieZLike()
	{
	   using (Northwind db = new())
	   {
		  TytulSekcji("Dopasowanie wzorców z Like");

		  Write("Wprowadź część nazwy produktu: ");
		  string? wejscie = ReadLine();

		  if (string.IsNullOrWhiteSpace(wejscie))
		  {
			 Blad("Nie podano części nazwy produktu.");
			 return;
		  }

		  IQueryable<Product> produkty = db.Products?
			 .Where(p => EF.Functions.Like(p.ProductName, $"%{wejscie}%"));

		  if ((products is null) || (!produkty.Any()))
		  {
			 Blad("Nie znaleziono produktów.");
			 return;
		  }

		  foreach (Product produkt in produkty)
		  {
			 WriteLine($"{0}: w magazynie jest {1} sztuk. Produkt nie jest już 
			 wytwarzany? {3}",
				produkt.ProductName, produkt.Stock, produkt.Discontinued);
		  }
	   }
	}


	static void PobierzLosowyProdukt()
	{
	  using (Northwind db = new())
	  {
		TytulSekcji("Pobieranie losowego produktu");

		int? liczbaWierszy = db.Products?.Count();
		if (liczbaWierszy == null)
		{
		  Blad("Tabela produktów jest pusta.");
		  return;
		}

		Product? p = db.Products?.FirstOrDefault(
		  p => p.ProductId == (int)(EF.Functions.Random() * liczbaWierszy));

		if (p == null)
		{
		  Blad("Nie znaleziono produktu.");
		  return;
		}

		WriteLine($"Losowy produkt: {p.ProductId} {p.ProductName}");
	  }
	}

}
