using Microsoft.EntityFrameworkCore; // ExecuteUpdate, ExecuteDelete
using Microsoft.EntityFrameworkCore.ChangeTracking; // EntityEntry<T>
using BibliotekaWspolna; // Northwind, Product

partial class Program
{
  static void WypiszProdukty(int[]? idProduktowDoWyroznienia = null)
  {
    using (Northwind db = new())
    {
      if ((db.Products is null) || (!db.Products.Any()))
      {
        Blad("Nie znaleziono produktów.");
        return;
      }

      WriteLine("| {0,-3} | {1,-35} | {2,8} | {3,5} | {4} |",
        "Id", "Nazwa produktu", "Cena", "Sztuk", "Nieprod.");

      foreach (Product p in db.Products)
      {
        ConsoleColor poprzedniKolor = ForegroundColor;

        if ((idProduktowDoWyroznienia is not null) &&
          idProduktowDoWyroznienia.Contains(p.ProductId))
        {
          ForegroundColor = ConsoleColor.Green;
        }

        WriteLine("| {0:000} | {1,-35} | {2,8:$#,##0.00} | {3,5} | {4} |",
          p.ProductId, p.ProductName, p.Cost, p.Stock, p.Discontinued);
        ForegroundColor = poprzedniKolor;
      }
    }
  }
  
  static bool DodajProdukt(
	  int idKategorii, string nazwaProduktu, decimal? cena)
	{
	   using (Northwind db = new())
	   {
		  if (db.Products is null) return (0, 0);

		  Product nowyProdukt = new() 
		  {
			 CategoryID = idKategorii,
			 ProductName = nazwaProduktu,
			 Koszt = cena,
			 Stock = 72
		  };

		  // oznacz produkt jako dodany w systemie śledzenia zmian
		  EntityEntry<Product> encja = db.Products.Add(nowyProdukt);
		  WriteLine($"Stan: {encja.State}, ProductId: {nowyProdukt.ProductId}");

		  // zapisz wszystkie zmiany w bazie
		  int zmienione = db.SaveChanges();
		  WriteLine($"Stan: {encja.State}, ProductId: {nowyProdukt.ProductId}");

		  return (zmienione, nowyProdukt.ProductId);
	   }
	}


	static (int zmienione, int idProduktu) ZwiekszCeneProduktu(
	   string poczatekNazwy, decimal kwota)
	{
	   using (Northwind db = new())
	   {
		  if (db.Products is null) return (0, 0);

		  // pobierz pierwszy produkt, którego nazwa zaczyna się od wartości parametru nazwa
		  Product produktDoAktualizacji = db.Products.First(
			 p => p.ProductName.StartsWith(poczatekNazwy));

		  produktDoAktualizacji.Koszt += kwota;

		  int zmienione = db.SaveChanges();

		  return (zmienione, produktDoAktualizacji.ProductId);
	   }
	}


	static int UsunProdukty(string poczatekNazwy)
	{
	   using (Northwind db = new())
	   {
		  IQueryable<Product>? produkty = db.Products?.Where(
			 p => p.ProductName.StartsWith(poczatekNazwy));

		  if ((produkty is null) || (!produkty.Any()))
		  {
			 WriteLine("Nie znaleziono produktów do usunięcia.");
			 return 0;
		  }
		  else
		  {
			 if (db.Products is null) return 0;

			 db.Products.RemoveRange(produkty);
		  }

		  int zmienione = db.SaveChanges();
		  return zmienione;
	   }
	}


	static (int zmienione, int[]? idProduktow) SzybkszeZwiekszanieCenProduktow(
	  string poczatekNazwy, decimal kwota)
	{
	  using (Northwind db = new())
	  {
		if (db.Products is null) return (0, null);

		// Pobieranie produktów, których nazwy zaczynają się podanym ciągiem znaków
		IQueryable<Product>? produkty = db.Products.Where(
		  p => p.ProductName.StartsWith(poczatekNazwy));

		int zmienione = produkty.ExecuteUpdate(s => s.SetProperty(
		  p => p.Koszt, // Wyrażenie lambda wybierające właściwość
		  p => p.Koszt + kwota)); // Wyrażenie lambda z wartością modyfikującą

		int[] idProduktow = produkty.Select(p => p.ProductId).ToArray();

		return (zmienione, idProduktow);
	  }
	}


	static int LepszeUsuwanieProduktow(string poczatekNazwy)
	{
	  using (Northwind db = new())
	  {
		int zmienione = 0;

		IQueryable<Product>? produkty = db.Products?.Where(
		  p => p.ProductName.StartsWith(poczatekNazwy));

		if ((products is null) || (!products.Any()))
		{
		  WriteLine("Nie znaleziono produktów do usunięcia.");
		  return 0;
		}
		else
		{
		  zmienione = produty.ExecuteDelete();
		}
		return zmienione;
	  }
	}


	static int UsunProdukty(string poczatekNazwy)
	{
	   using (Northwind db = new())
	   {
		  using (IDbContextTransaction t = db.Database.BeginTransaction())
		  {
			 WriteLine($"Transakcja uruchomiona z poziomem izolacji: {0}",
				arg0: t.GetDbTransaction().IsolationLevel);

			 IQueryable<Product>? produkty = db.Products.Where(
				p => p.ProductName.StartsWith(poczatekNazwy));

			 if ((produkty is null) || (!produkty.Any()))
			 {
				WriteLine("Nie znaleziono produktów do usunięcia.");
				return 0;
			 }
			 else
			 {
				db.Products.RemoveRange(produkty);
			 }

			 int zmienione = db.SaveChanges();
			 t.Commit();
			 return zmienione;
		  }
	   }
	}

}
