namespace Biblioteka;

public class OsobaComparer : IComparer<Osoba?>
{
  public int Compare(Osoba? x, Osoba? y)
  {
    if ((x is not null) && (y is not null))
    {
      if (x.Nazwisko is null)
      {
        // Jeżeli ta i inna osoba mają wartość null
        // jako nazwisko, to uznajemy je za takie same
        if (y.Nazwisko is null) return 0;

        // w przeciwnym wypadku osoba x staje za osobą y
        return 1;
      }
      else
      {
        if (y.Nazwisko is null)
        {
          return -1;
        }
      }

      // Jeżeli obie wartości Nazwiska nie są null,
         

      // Porównujemy długości nazwuisk...
      int result = x.Nazwisko.Length
        .CompareTo(y.Nazwisko.Length);

      /// ...jeżeli długości są takie same... 
      if (result == 0)
      {
        // ...to porównujemy nazwiska alfabetycznie...
        return x.Nazwisko.CompareTo(y.Nazwisko);
      }
      else
      {
        // ...w przeciwnym wypadku ważne są tylko długości.
        return result;
      }
    }
    else if ((x is not null) && (y is null))
    {
      return -1; // x przed y
    }
    else if ((x is null) && (y is not null))
    {
      return 1; // x za y
    }
    else
    {
      return 0; // x i y są takie same
    }
  }
}
