﻿using System.Text.Json; // JsonSerializer

using static System.Environment;
using static System.IO.Path;

Ksiazka csharp11 = new(tytul:
  "C# 11 and .NET 7 – Modern Cross-Platform Development ")
{
   Autor = "Mark J Price",
   DataPublikacji = new(year: 2022, month: 11, day: 8),
   LiczbaStron = 823,
   Utworzone = DateTimeOffset.UtcNow,
};

JsonSerializerOptions opcje = new()
{
   IncludeFields = true, // Dołącza wszystkie pola
   PropertyNameCaseInsensitive = true,
   WriteIndented = true,
   PropertyNamingPolicy = JsonNamingPolicy.CamelCase,
};

string sciezkaPliku = Combine(CurrentDirectory, "ksiazka.json");

using (Stream strumienPliku = File.Create(sciezkaPliku))
{
   JsonSerializer.Serialize<Ksiazka>(
     utf8Json: strumienPliku, value: csharp11, opcje);
}

WriteLine("Do pliku {0} zapisano {1:N0} bajtow",
  arg0: sciezkaPliku,
  arg1: new FileInfo(sciezkaPliku).Length);

WriteLine();

// Wyświetlenie zserializowanego grafu obiektów
WriteLine(File.ReadAllText(sciezkaPliku));
