﻿using System; // DateTime
using System.Collections.Generic; // List<T>

using static System.Console;

namespace BibliotekaWspolna
{
  public partial class Osoba : object
  {
    
    // pola
    public string Nazwisko;
    public DateTime DataUrodzenia;
    public AntyczneCudaSwiata UlubionyAntycznyCud;
    public AntyczneCudaSwiata DoOdwiedzenia;
    public List<Osoba> Dzieci = new List<Osoba>();

    // stałe
    public const string Gatunek = "Homo Sapiens";

    // pola tylko do odczytu
    public readonly string Planeta = "Ziemia";
    public readonly DateTime Utworzono;

    // konstruktory 
    public Osoba()
    {
         // ustala domyślne wartości pól,
         // w tym pól tylko do odczytu
         Nazwisko = "Nieznane";
         Utworzono = DateTime.Now;
    }

    public Osoba(string wstepneNazwisko, string wstepnaPlanetaPochodzenia)
    {
       Nazwisko = wstepneNazwisko;
       Planeta = wstepnaPlanetaPochodzenia;
       Utworzono = DateTime.Now;
    }


      // dekonstruktory
      public void Deconstruct(out string nazwisko, out DateTime dataUrodzenia)
    {
      nazwisko = Nazwisko;
      dataUrodzenia = DataUrodzenia;
    }

    public void Deconstruct(out string nazwisko, 
      out DateTime dataUrodzenia, out AntyczneCudaSwiata ulubiony)
    {
      nazwisko = Nazwisko;
      dataUrodzenia = DataUrodzenia;
      ulubiony = UlubionyAntycznyCud;
    }

    // metody
    public void WypiszWKonsoli()
    {
       WriteLine($"{Nazwisko} urodził(a) się w {DataUrodzenia:dddd}");
    }

    public string PodajPochodzenie()
    {
       return $"{Nazwisko} pochodzi z planety {Planeta}";
    }


      public (string, int) WezOwoce()
    {
      return ("Jabłka", 5);
    }

    public (string Nazwa, int Liczba) PobierzNazwaneOwoce()
    {
      return (Nazwa: "Jabłka", Liczba: 5);
    }

    public string PowiedzCzesc()
    {
      return $"{Nazwisko} mówi 'Cześć!'";
    }

    public string PowiedzCzesc(string imie)
    {
      return $"{Nazwisko} mówi 'Cześć, {imie}!'";
    }

    public string ParametryOpcjonalne(
      string polecenie = "Biegnij!",
      double liczba = 0.0,
      bool aktywne = true)
    {
      return string.Format(
        format: "polecenie to {0}, liczba to {1}, aktywne to {2}",
        arg0: polecenie, 
        arg1: liczba, 
        arg2: aktywne);
    }

    public void PrzekazywanieParametrów(int x, ref int y, out int z)
    {
       // Parametry typu out nie mają wartości domyślnej
       // i muszą zostać zainicjowane wewnątrz metody

         z = 99;

      // zwiększenie wartości wszystkich parametrów
      x++;
      y++;
      z++;
    }
  }
}
