using Microsoft.OpenApi.Models;
using Microsoft.AspNetCore.Mvc.Formatters;
using BibliotekaWspolna; // DodajKontekstNorthwind
using Northwind.WebApi.Repozytoria;
using Swashbuckle.AspNetCore.SwaggerUI; // SubmitMethod
using Microsoft.AspNetCore.HttpLogging; // HttpLoggingFields

using static System.Console;

var builder = WebApplication.CreateBuilder(args);

builder.WebHost.UseUrls("https://localhost:5002/");

// Add services to the container.

builder.Services.AddCors();

builder.Services.AddNorthwindContext();

builder.Services.AddControllers(opcje =>
{
  WriteLine("Domyślne formatery wyjścia:");
  foreach (IOutputFormatter formatter in opcje.OutputFormatters)
  {
    OutputFormatter? mediaFormatter = formatter as OutputFormatter;
    if (mediaFormatter == null)
    {
      WriteLine($"  {formatter.GetType().Name}");
    }
    else // klasa OutputFormatter ma właściwość SupportedMediaTypes
    {
      WriteLine("  {0}, typy mediów: {1}",
        arg0: mediaFormatter.GetType().Name,
        arg1: string.Join(", ",
          mediaFormatter.SupportedMediaTypes));
    }
  }
})
.AddXmlDataContractSerializerFormatters()
.AddXmlSerializerFormatters();

builder.Services.AddSwaggerGen(c =>
{
  c.SwaggerDoc("v1", new() { Title = "Northwind Service API", Version = "v1" });
});

builder.Services.AddScoped<IRepozytoriumCustomer, RepozytoriumCustomer>();

builder.Services.AddHttpLogging(options =>
{
  options.LoggingFields = HttpLoggingFields.All;
  options.RequestBodyLogLimit = 4096; // default is 32k
  options.ResponseBodyLogLimit = 4096; // default is 32k
});

builder.Services.AddHealthChecks()
  .AddDbContextCheck<NorthwindContext>();

var app = builder.Build();

// Configure the HTTP request pipeline.

app.UseCors(configurePolicy: options =>
{
  options.WithMethods("GET", "POST", "PUT", "DELETE");
  options.WithOrigins(
    "https://localhost:5001" // umożliwia obsługę żądań od klienta MVC
  );
});

app.UseHttpLogging();

if (builder.Environment.IsDevelopment())
{
  app.UseSwagger();
  app.UseSwaggerUI(c =>
  {
    c.SwaggerEndpoint("/swagger/v1/swagger.json",
      "Northwind Service API Version 1");

    c.SupportedSubmitMethods(new[] {
      SubmitMethod.Get, SubmitMethod.Post,
      SubmitMethod.Put, SubmitMethod.Delete });
  });
}

app.UseHttpsRedirection();

app.UseAuthorization();

app.UseHealthChecks(path: "/jaksieczujesz");

app.UseMiddleware<NaglowkiZabezpieczajace>();

app.MapControllers();

app.Run();
