using static System.Console;

namespace Biblioteka;

public class Pracownik : Osoba
{
  public string? KodPracownika { get; set; }
  public DateTime DataZatrudnienia { get; set; }

  public new void WypiszWKonsoli()
  {
    WriteLine(format:
      "{0}, data urodzenia {1:dd/MM/yy}, data zatrudnienia {2:dd/MM/yy}",
      arg0: Nazwisko,
      arg1: DataUrodzenia,
      arg2: DataZatrudnienia);
  }

  // overridden methods
  public override string ToString()
  {
    return $"Kod pracownika {Nazwisko} to {KodPracownika}";
  }
}
