﻿// Tablica typu string jest sekwencją implementującą interfejs IEnumerable<string>
string[] imiona = new[] { "Michał", "Pamela", "Jan", "Darek",
  "Agnieszka", "Kuba", "Tomek", "Celina" };

TytulSekcji("Opóźnione wykonanie");

// Pytanie: Które imiona kończą się na K?
// (zapisane za pomocą metody rozszerzającej LINQ)
var zapytanie1 = imiona.Where(imie => imie.EndsWith("k"));

// Pytanie: Które imiona kończą się na K?
// (zapisane za pomocą rozszerzonej składni LINQ)
var zapytanie2 = from imie in imiona where imie.EndsWith("k") select imie;

// Odpowiedź jako tablica ciągów znaków z wartościami Darek i Tomek
string[] wynik1 = zapytanie1.ToArray();

// Odpowiedź jako lista ciągów znaków z wartościami Darek i Tomek
List<string> wynik2 = zapytanie2.ToList();

// Odpowiedź jest zwracana w trakcie iterowania po wynikach
foreach (string imie in zapytanie1)
{
   WriteLine(imie); // Wypisuje Darek
   imiona[6] = "Tomasz"; // Zmienia Tomek na Tomasz
                         // W drugiej iteracji imię Tomasz nie kończy się literą K
}

TytulSekcji("Pisanie zapytań");

// var zapytanie = names.Where(
//   new Func<string, bool>(ImionaDluzszeNizCztery));

// var zapytanie = names.Where(ImionaDluzszeNizCztery);

IOrderedEnumerable<string> zapytanie = imiona
  .Where(imie => imie.Length > 4)
  .OrderBy(imie => imie.Length)
  .ThenBy(imie => imie);

foreach (string element in zapytanie)
{
   WriteLine(element);
}

TytulSekcji("Filtrowanie według typu");

List<Exception> wyjatki = new()
{
  new ArgumentException(),
  new SystemException(),
  new IndexOutOfRangeException(),
  new InvalidOperationException(),
  new NullReferenceException(),
  new InvalidCastException(),
  new OverflowException(),
  new DivideByZeroException(),
  new ApplicationException()
};

IEnumerable<ArithmeticException> wyjatkiArytmetyczne =
  wyjatki.OfType<ArithmeticException>();

foreach (ArithmeticException wyjatek in wyjatkiArytmetyczne)
{
   WriteLine(wyjatek);
}

string[] zespol1 = new[]
  { "Rafał", "Grzegorz", "Jan", "Gabrysia" };

string[] zespol2 = new[]
  { "Jacek", "Stefan", "Daniel", "Jacek", "Janina" };

string[] zespol3 = new[]
  { "Darek", "Jacek", "Jacek", "Malina", "Celina" };

TytulSekcji("Zespoły");

Wyjscie(zespol1, "Zespół 1");
Wyjscie(zespol2, "Zespół 2");
Wyjscie(zespol3, "Zespół 3");

TytulSekcji("Operacje na zbiorach");

Wyjscie(zespol2.Distinct(), "zespol2.Distinct():");
Wyjscie(zespol2.DistinctBy(imie => imie.Substring(0, 2)),
  " zespol2.DistinctBy(imie => imie.Substring(0, 2)):");
Wyjscie(zespol2.Union(zespol3), "zespol2.Union(zespol3):");
Wyjscie(zespol2.Concat(zespol3), "zespol2.Concat(zespol3):");
Wyjscie(zespol2.Intersect(zespol3), "zespol2.Intersect(zespol3):");
Wyjscie(zespol2.Except(zespol3), "zespol2.Except(zespol3):");
Wyjscie(zespol1.Zip(zespol2, (c1, c2) => $"{c1} przeciw {c2}"),
  "zespol1.Zip(zespol2):");

