﻿using System.Net.Http.Json; // GetFromJsonAsync, ReadFromJsonAsync
using BibliotekaWspolna; // Customer

namespace Northwind.BlazorWasm.Client.Data
{
  public class SerwisNorthwind : ISerwisNorthwind
  {
    private readonly HttpClient http;

    public SerwisNorthwind(HttpClient http)
    {
      this.http = http;
    }

    public Task<List<Customer>> PobierzKlientowAsync()
    {
      return http.GetFromJsonAsync
        <List<Customer>>("api/klienci");
    }

    public Task<List<Customer>> PobierzKlientowAsync(string kraj)
    {
      return http.GetFromJsonAsync
        <List<Customer>>($"api/klienci/w/{kraj}");
    }

    public Task<Customer?> PobierzKlientaAsync(string id)
    {
      return http.GetFromJsonAsync
        <Customer>($"api/klienci/{id}");
    }

    public async Task<Customer>
      UtworzKlientaAsync(Customer k)
    {
      HttpResponseMessage odpowiedz = await
        http.PostAsJsonAsync("api/klienci", k);

      return await odpowiedz.Content
        .ReadFromJsonAsync<Customer>();
    }

    public async Task<Customer> AktualizujKlientaAsync(Customer k)
    {
      HttpResponseMessage odpowiedz = await
        http.PutAsJsonAsync("api/klienci", k);

      return await odpowiedz.Content
        .ReadFromJsonAsync<Customer>();
    }

    public async Task UsunKlientaAsync(string id)
    {
      HttpResponseMessage odpowiedz = await
        http.DeleteAsync($"api/klienci/{id}");
    }
  }
}
