﻿using System.Text.RegularExpressions;

using static System.Console;

Write("Podaj swój wiek: ");
string? wejscie = ReadLine();

Regex kontrolaWieku = new(@"^\d+$");

if (kontrolaWieku.IsMatch(wejscie))
{
   WriteLine("Dziękuję!");
}
else
{
   WriteLine($"To nie jest prawidłowy wiek: {wejscie}");
}

string filmy = "\"Złap mnie, jeśli potrafisz\",\"Kocha, lubi, szanuje\",\"Ja, robot\"";

WriteLine($"Filmy do podziału: {filmy}");

string[] filmyProstyPodzial = filmy.Split(',');

WriteLine("Próba podziału metodą String.Split:");
foreach (string film in filmyProstyPodzial)
{
   WriteLine(film);
}

WriteLine();

var csv = new Regex("(?:^|,)(?=[^\"]|(\")?)\"?((?(1)[^\"]*|[^,\"]*))\"?(?=,|$)");

MatchCollection filmySprytnyPodzial = csv.Matches(filmy);

WriteLine("Próba podziału za pomocą wyrażenia regularnego:");
foreach (string film in filmySprytnyPodzial)
{
   WriteLine(film.Groups[2].Value);
}

