﻿using System.Diagnostics.CodeAnalysis;

namespace Generics;

class Program
{
    static void Main()
    {
    }
}

public class GenericBase1<T>
{
    public T? Item { get; set; }
}

public class GenericBase2<TKey, TValue>
    where TValue : class
{
    public TKey? Key { get; set; }
    public TValue? Value { get; set; }
}

public class NonGenericDerived : GenericBase1<string>
{
}

public class GenericDerived<T> : GenericBase1<T>
{
}

public class MixedDerived<T> : GenericBase2<string, T>
    where T : class
{
}

public class SelfAsTypeArgument : IComparable<SelfAsTypeArgument>
{
    public int CompareTo([AllowNull] SelfAsTypeArgument other) => throw new NotImplementedException();
}

public class Curious<T>
    where T : Curious<T>
{
}

// Tylko w celach demonstracyjnych - te typy są zdefiniowane w .NET, więc nie trzeba
// ich definiować samodzielnie
#if false
public interface IEnumerable<out T> : IEnumerable

public interface IComparer<in T>
#endif