﻿namespace DelegateConversion
{
    class Program
    {
        public static bool IsLongString(object o)
        {
            return o is string s && s.Length > 20;
        }

        static void Main(string[] args)
        {
            Predicate<object> po = IsLongString;
            Predicate<string> ps = po;
            Console.WriteLine(ps("Zbyt krótki."));
        }

        // Ten przykład prezentuje rozwiązanie, które nie będzie działać.
        // Zmień #if false na #if true, by zobaczyć błąd kompilacji
#if false
        public static void IllegalConversion()
        {
            Predicate<string> pred = IsLongString;
            Func<string, bool> f = pred;  // Spowoduje zgłoszenie błędu kompilacji
        }
#endif
    }
}
