﻿using System.Diagnostics;
using System.Globalization;

namespace BasicCoding;

static class StringsAndChars
{
    const string name = "Ian";
    const int age = 46;

    internal static void CharactersVsChars()
    {
        char[] chars = { 'c', 'a', 'f', 'e', (char)0x301, 's' };
        string text = new string(chars);

        Console.WriteLine(text);
    }

    internal static void ExpressionsInStrings()
    {
        string message = $"{name} ma {age} lat";

        double width = 3, height = 4;
        string info = $"Przeciwprostokątna: {Math.Sqrt(width * width + height * height)}";

        Console.WriteLine(message);
        Console.WriteLine(info);
    }

    internal static void StringInterpolationEffect()
    {
        double width = 3, height = 4;

        string message = string.Format("{0} ma {1} lat", name, age);
        string info = string.Format(
            "Przeciwprostokątna: {0}",
            Math.Sqrt(width * width + height * height));

        Console.WriteLine(message);
        Console.WriteLine(info);
    }

    internal static void FormatSpecifiers()
    {
        string message = $"{name} ma {age:f1} lat";

        Console.WriteLine(message);
    }

    internal static void FormatSpecifiersInvariantCulture()
    {
        decimal v = 1234567.654m;
        string i = string.Create(CultureInfo.InvariantCulture, $"Liczba {v:N}");
        string f = string.Create(new CultureInfo("fr"), $"Liczba {v:N}");
        string frc = string.Create(new CultureInfo("fr-FR"), $"Liczba {v:C}");
        string cac = string.Create(new CultureInfo("fr-CA"), $"Liczba {v:C}");
    }

    internal static void PotentiallyUnusedInterpolatedString(
        object myApplicationModel,
        bool everythingIsOk)
    {
        Debug.Assert(everythingIsOk, $"Coś jest *nie* w porządku: {myApplicationModel}");
    }
}
