﻿namespace BasicCoding;

internal static class FlowControl
{
    internal static void SimpleIf(int age)
    {
        if (age < 18)
        {
            Console.WriteLine("Jesteś zbyt młody, by kupować alkohol w barze.");
        }
    }

    [System.Diagnostics.CodeAnalysis.SuppressMessage(
        "Style",
        "IDE0011:Add braces",
        Justification = "Ten przykład celowo prezentuje nieprawidłowe rozwiązanie")]
    internal static void BadIf(bool authenticationCodesCorrect)
    {
        if (authenticationCodesCorrect)
            SendTransferConfirmation();
            TransferFunds();
    }

    internal static void IfAndElse(bool optimistic)
    {
        if (optimistic)
        {
            Console.WriteLine("Szklanka jest w połowie pełna.");
        }
        else
        {
            Console.WriteLine("Szklanka jest w połowie pusta.");
        }
    }

    internal static void MultipleElses(double temperatureInCelsius)
    {
        if (temperatureInCelsius < 15)
        {
            Console.WriteLine("Za zimno");
        }
        else if (temperatureInCelsius > 32)
        {
            Console.WriteLine("Za gorąco");
        }
        else
        {
            Console.WriteLine("Optymalnie");
        }
    }

    internal static void MultipleElsesLotsOfBlocks(double temperatureInCelsius)
    {
        if (temperatureInCelsius < 15)
        {
            Console.WriteLine("Za zimno");
        }
        else
        {
            if (temperatureInCelsius > 32)
            {
                Console.WriteLine("Za gorąco");
            }
            else
            {
                Console.WriteLine("Optymalnie");
            }
        }
    }

    internal static void SwitchWithStrings(string workStatus)
    {
        switch (workStatus)
        {
        case "SzefWPracowni":
            WorkDiligently();
            break;

        case "BrakZblizajacegoSieTerminu":
        case "TerminNaKarku":
            CheckTwitter();
            CheckEmail();
            CheckTwitter();
            ContemplateGettingOnWithSomeWork();
            CheckTwitter();
            CheckTwitter();
            break;

        case "TerminZostalPrzekroczony":
            WorkFuriously();
            break;

        default:
            CheckTwitter();
            CheckEmail();
            break;
        }
    }

    // Aby zobaczyć błąd kompilatora dla Listingu 70, zmień to:
#if false
//  na:
// #if true
    internal static void IllegalSwitchFallThrough(string x)
    {
        switch (x)
        {
        case "Jeden":
            Console.WriteLine("Jedne");
        case "Two":  // Tego kodu nie uda się skompilować!
            Console.WriteLine("Jeden i dwa");
            break;
        }
    }
#endif

    internal static void SwitchFallThrough(string x)
    {
        switch (x)
        {
        case "Jeden":
            Console.WriteLine("Jeden");
            goto case "Dwa";
        case "Dwa":
            Console.WriteLine("Jeden i dwa");
            break;
        }
    }

    internal static void WhileLoop(StreamReader reader)
    {
        while (!reader.EndOfStream)
        {
            Console.WriteLine(reader.ReadLine());
        }
    }

    internal static void DoLoop()
    {
        char k;
        do
        {
            Console.WriteLine("Naciśnij x, aby zakończyć.");
            k = Console.ReadKey().KeyChar;
        }
        while (k != 'x');
    }

    internal static void ForLoops(int[] myArray)
    {
        for (int i = 0; i < myArray.Length; i++)
        {
            myArray[i] *= 2;
        }

        for (int i = 0, j = 0; i < myArray.Length; i++, j++)
        {
            myArray[i] = myArray[j] / 2;
        }
    }

    internal static void NestedLoop(int[,] myArray)
    {
        int height = myArray.GetLength(0);
        int width = myArray.GetLength(1);

        for (int j = 0; j < height; ++j)
        {
            for (int i = 0; i < width; ++i)
            {
                Console.WriteLine($"{i},{j}: {myArray[i, j]}");
            }
        }
    }

    internal static void ForeachLoops()
    {
        string[] messages = GetMessagesFromSomewhere();
        foreach (string message in messages)
        {
            Console.WriteLine(message);
        }

        static string[] GetMessagesFromSomewhere() => new[] { "Witaj", "świecie!" };
    }

    public static void ShowMessages(IEnumerable<string> messages)
    {
        foreach (string message in messages)
        {
            Console.WriteLine(message);
        }
    }

    private static void SendTransferConfirmation() => Console.WriteLine("Przesyłanie potwierdzenia transferu");

    private static void TransferFunds() => Console.WriteLine("Przekazywanie funduszy");

    private static void WorkDiligently() => Console.WriteLine("Robimy z Jacka durnia");

    private static void CheckTwitter() => Console.WriteLine("Odśweżanie");  

    private static void CheckEmail() => Console.WriteLine("Przewijamy");

    private static void ContemplateGettingOnWithSomeWork() => Console.WriteLine("Ech...");

    private static void WorkFuriously() => Console.WriteLine("A oto i Janek!");
}
