# Rozdział 5. - Przykłady

Przykłady z rozdziału 5. (Kolekcje) książki C# 10.0. Programowanie

## Tablice

* [Listing 1. Tworzenie tablic](Collections/Arrays/Program.cs#L15-L16)
* [Listing 2. Odwoływanie się do elementów tablic](Collections/Arrays/Program.cs#L18-L22)
* [Listing 3. Złożone odwołania do tablic](Collections/Arrays/ConvolutedArrayAccess.cs#L7-L13)
* [Listing 4. Jak nie należy modyfikować tablicy o elementach typu niezmiennego](Collections/Arrays/Program.cs#L8-L11)
* [Listing 5. Modyfikacja tablic o elementach typu niezmiennego](Collections/Arrays/Program.cs#L24-L25)
* [Listing 6. Pracochłonny sposób inicjalizacji tablic](Collections/Arrays/ArrayInitialization.cs#L7-L12)
* [Listing 7. Składnia inicjalizatora tablic](Collections/Arrays/ArrayInitialization.cs#L17-L18)
* [Listing 8. Skrócona składnia inicjalizatora tablic](Collections/Arrays/ArrayInitialization.cs#L23-L24)
* [Listing 9. Składnia inicjalizatora tablic wykorzystująca automatyczne określanie typu](Collections/Arrays/ArrayInitialization.cs#L29-L30)
* [Listing 10. Tablice jako argumenty](Collections/Arrays/ArrayInitialization.cs#L35)
* [Listing 11. Przeszukiwanie tablicy przy użyciu metody IndexOf](Collections/Arrays/Searching.cs#L9-L17)
* [Listing 12. Przeszukiwanie tablicy przy użyciu metody FindIndex](Collections/Arrays/Searching.cs#L20-L23)
* [Listing 13. Zastosowanie wyrażenia lambda w metodzie FindIndex](Collections/Arrays/Searching.cs#L27-L28)
* [Listing 14. Odnajdywanie wielu wartości przy użyciu metody FindAll](Collections/Arrays/Searching.cs#L31-L32)
* [Listing 15. Wydajność wyszukiwania oraz metoda BinarySearch](Collections/Arrays/Searching.cs#L83-L91)
* [Listing 16. Tworzenie tablicy nieregularnej](Collections/Arrays/ArrayInitialization.cs#L40-L47)
* [Listing 17. Tablice prostokątne](Collections/Arrays/ArrayInitialization.cs#L52-L58)
* [Listing 18. Sześcienna „prostokątna” tablica o wymiarach 2 na 3 na 5](Collections/Arrays/ArrayInitialization.cs#L60-L72)

## List&lt;T&gt;

* [Listing 19. Stosowanie list typu List<T>](Collections/ListsAndSequences/Program.cs#L7-L19)
* [Listing 20. Inicjalizacja list](Collections/ListsAndSequences/Program.cs#L27)
* [Listing 21. Inicjalizacja listy o typie określanym na podstawie zmiennej](Collections/ListsAndSequences/Program.cs#L32)

## Interfejsy list i sekwencji

* [Listing 22. Interfejsy IEnumerable<T> oraz IEnumerable](Collections/ListsAndSequences/Program.cs#L40-L48)
* [Listing 23. Interfejsy IEnumerable<T> oraz IEnumerable](Collections/ListsAndSequences/Program.cs#L50-L60)
* [Listing 24. Interfejsy IAsyncEnumerable<T> oraz IAsyncEnumerator<T>](Collections/ListsAndSequences/Program.cs#L62-L73)
* [Listing 25. Interfejs ICollection<T> ](Collections/ListsAndSequences/Program.cs#L75-L85)
* [Listing 26. Interfejs IList<T>](Collections/ListsAndSequences/Program.cs#L87-L94)
* [Listing 27. Próba (nieudana) powiększenia tablicy](Collections/ListsAndSequences/Program.cs#L21-L22)

## Implementacja list i sekwencji

* [Listing 28. Prosty iterator](Collections/ImplementingSequences/Program.cs#L7-L21)
* [Listing 29. Bardzo prosty iterator](Collections/ImplementingSequences/Program.cs#L23-L28)
* [Listing 30. Nieskończony iterator](Collections/ImplementingSequences/Program.cs#L30-L42)
* [Listing 31. Samodzielna implementacja interfejsu IEnumerable<T>](Collections/ImplementingSequences/FibonacciEnumerable.cs#L6-L46)
* [Listing 32. Weryfikacja argumentów iteratora](Collections/ImplementingSequences/ArgumentValidation.cs#L7-L28)

## Odwołania do elementów z użyciem indeksów i zakresów

* [Listing 33. Odwołanie do ostatniego elementu tablicy wyrażające położenie względem jej końca](Collections/RangeAndIndex/Program.cs#L7-L8)
* [Listing 34. Pobieranie fragmentu tablicy przy wykorzystaniu operatora zakresu](Collections/RangeAndIndex/Program.cs#L10-L12)
* [Listing 35. Indeksy określające położenie względem początku oraz względem końca](Collections/RangeAndIndex/Program.cs#L14-L22)
* [Listing 36. Indeksowanie względem końca i rozwiązania wcześniejsze](Collections/RangeAndIndex/Program.cs#L24-L28)
* [Listing 37. Różne zakresy](Collections/RangeAndIndex/Program.cs#L30-L46)
* [Listing 38. Pobieranie fragmentu łańcucha przy użyciu zakresu](Collections/RangeAndIndex/Program.cs#L48-L50)
* [Listing 39. Pobieranie fragmentu ArraySegment<int> przy użyciu operatora zakresu](Collections/RangeAndIndex/Program.cs#L66-L68)
* [Listing 40. Pobieranie fragmentu przy użyciu typu Span<T> i operatora zakresu](Collections/RangeAndIndex/Program.cs#L73-L77)
* [Listing 41. Minimalistyczna obsługa indeksów](Collections/RangeAndIndex/Indexable.cs#L3-L8)
* [Listing 42. Minimalistyczne rozwiązanie pozwalające na stosowanie zakresów](Collections/RangeAndIndex/Rangeable.cs#L3-L8)
* [Listing 43. Jak są przekształcane indeksy zakresów](Collections/RangeAndIndex/Program.cs#L52-L61)

## Słowniki

* [Listing 44. Zastosowanie słownika jako elementu pamięci podręcznej](Collections/Dictionaries/UserCache.cs#L3-L34)
* [Listing 45. Pobieranie danych ze słownika przy użyciu indeksatora](Collections/Dictionaries/AnotherCache.cs#L9)
* [Listing 46. Składnia inicjalizatora słownika](Collections/Dictionaries/Initializers.cs#L7-L12)
* [Listing 47. Składnia inicjalizatora obiektu zastosowana podczas tworzenia słownika](Collections/Dictionaries/Initializers.cs#L17-#L22)
* [Listing 48. Słownik, w którym nie jest uwzględniana wielkość liter](Collections/Dictionaries/Program.cs#L1-L7)

## Zbiory

* [Listing 49. Zastosowanie zbioru do wykrywania powtarzających się elementów](Collections/Sets/Program.cs#L10-L20)

## Kolekcje niezmienne

* [Listing 50. Tworzenie niezmiennego słownika](Collections/ImmutableCollections/Program.cs#L15-L18)
* [Listing 51. Tworzenie niezmiennego słownika z użyciem obiektu budowniczego](Collections/ImmutableCollections/Program.cs#L25-L30)
