﻿namespace Constraints;

public class GenericComparer<T> : IComparer<T>
    where T : IComparable<T>
{
    public int Compare(T? x, T? y)
    {
        if (x == null) { return y == null ? 0 : -1; }
        return x.CompareTo(y);
    }
}

// Kolejne dwa przykłady są zmodyfikowanymi wersjami klasy, której nie 
// można skompilować, gdyż w książce prezentujemy ja jako coś, co nie 
// będzie działać. To dlatego w kodach przykładów zostały one umieszczone
// w bloku #if false
#if false
public class GenericComparer<T> : IComparer<T>
{
    public int Compare(IComparable<T>? x, T? y)
    {
        if (x == null) { return y == null ? 0 : -1; }
        return x.CompareTo(y);
    }
}

public class GenericComparer<T> : IComparer<T>
{
    public int Compare(T? x, T? y)
    {
        if (x == null) { return y == null ? 0 : -1; }
        return x.CompareTo(y);
    }
}
#endif
