# Rozdział 3. - Przykłady

Przykłady z rozdziału 3. (Typy) książki C# 10.0. Programowanie

## Klasy

* [Listing 1. Prosta klasa](Typy/Classes/Counter.cs#L3-L12)
* [Listing 2. Stosowanie niestandardowej klasy](Typy/Classes/Program.cs#L3-L11)

### Składowe statyczne

* [Listing 3. Klasa ze składowymi statycznymi](Typy/ClassWithStaticMembers/Counter.cs#L3-L16)
* [Listing 4. Użycie składowej statycznej](Typy/ClassWithStaticMembers/Program.cs#L13)
* [Listing 5. Słowo kluczowe this](Typy/ClassWithStaticMembers/CounterUsingThis.cs#L10)

### Klasy statyczne

* [Listing 6. Normalny sposób stosowania składowych statycznych](Typy/StaticUse/Normal.cs)
* [Listing 7. Stosowanie składowych statycznych bez jawnego określania klasy](Typy/StaticUse/WithoutQualification.cs)

### Rekordy

* [Listing 8. Typ POD utworzony przy użyciu pól publicznych](Typy/Records/PodClass/WithFields/Person.cs#L3-L7)
* [Listing 9. Wymuszanie inicjalizacji pól poprzez zdefiniowanie konstruktora](Typy/Records/PodClass/WithPropertiesAndCtor/Person.cs#L3-L13)
* [Listing 10. Typ rekordu o składni pozycyjnej](Typy/Records/Positional/Person.cs#L3)
* [Listing 11. Stosowanie typu rekordu](Typy/Records/Positional/UsingPositionalRecords.cs#L7-L15)
* [Listing 12. Tworzenie zmodyfikowanej wersji niezmiennego rekordu](Typy/Records/Positional/UsingPositionalRecords.cs#L17-L21)
* [Listing 13. Typ rekordu z właściwościami których wartości można modyfikować](Typy/Records/Modifiable/Person.cs#L3-L13)
* [Listing 14. Porównywanie dwóch instancji typu](Typy/Records/Positional/UsingPositionalRecords.cs#L25-L30)
* [Listing 15. Zagnieżdżone typy rekordów](Typy/Records/Nested/Types.cs#L3-L4)
* [Listing 16. Stosowanie typów rekordów zagnieżdżonych](Typy/Records/Nested/UsingNestedRecords.cs#L7-L20)

### Typy referencyjne

* [Listing 17. Kopiowanie referencjiences](Typy/ReferenceTypes/Program.cs#L22-L30)
* [Listing 18. Porównywanie referencjices](Typy/ReferenceTypes/Program.cs#L35-L49)
* [Listing 19. Porównywanie wartościs](Typy/ReferenceTypes/Program.cs#L60-L75)
* [Listing 20. Określanie akceptowania wartości pustychity](Typy/Nullability/Program.cs#L3-L4)
* [Listing 21. Włączanie kontekstu ostrzeżenia nullable oraz adnotacji nullable w ustawieniach projektuult](Typy/Nullability/Nullability.csproj#L17-L19)
* [Listing 22. Odwołania z użyciem referencji akceptującej wartości pusterence](Typy/Nullability/Program.cs#L8-L18)
* [Listing 23. Operator null forgivingperator](Typy/Nullability/Program.cs#L22-L23)
* [Listing 24. Obsługa wartości pustych i wzorzec Try pes](Typy/Nullability/NonNullableAwareTryPattern.cs#L9-L17)
* [Listing 25. Użycie wzorca Try ze świadomą obsługą wartości pustychtern](Typy/Nullability/NullableAwareTryPattern.cs#L7-L15)
* [Listing 26. Atrybut nullablete](Typy/Nullability/NullableAwareTryPattern.cs#L17)
* [Listing 27. Tablice i akceptowanie wartości pustychty](Typy/Nullability/Program.cs#L27-L28)

## Struktury

* [Listing 28. Prosta struktura](Typy/Structs/Simple/Point.cs#L3-L15)
* [Listing 29. Obsługa niestandardowego sposobu porównywania](Typy/Structs/Point.cs#L3-L22)
* [Listing 30. Porównywanie instancji struktur](Typy/Structs/Program.cs#L9-L22)
* [Listing 31. Struktura przeznaczona tylko do odczytu](Typy/ReadOnlyStructs/Point.cs#L3-L14)
* [Listing 32. Struktura tylko do odczytu we właściwości tylko do odczytu](Typy/ReadOnlyStructs/LocationData.cs#L3-L13)
* [Listing 33. Typ record tylko do odczytu, typ record struct o modyfikowalnych właściwościach oraz typ readonly record struct](Typy/Records/RecordStructs.cs#L3-L13)

## Składowe

### Pola

 * [Listing 34. Stała](Typy/Fields/Program.cs#L5)

### Konstruktory

* [Listing 35. Błąd: nie podano identyfikatora URI](Typy/Constructors/Program.cs#L11)
* [Listing 36. Klasa z jednym konstruktorem](Typy/Constructors/Simple/Item.cs#L3-L12)
* [Listing 37. Użycie konstruktora](Typy/Constructors/Program.cs#L3)
* [Listing 38. Typ rekordu dysponujący konstruktorem wygenerowanym przez kompilator](Typy/Constructors//RecordGeneratedCtor/Item.cs#L3)
* [Listing 39. Niepusty konstruktor bezargumentowy](Typy/Constructors/Simple/ItemWithId.cs#L3-L12)
* [Listing 40. Typ rekordu z niestandardowym konstruktorem kopiującym](Typy/Constructors/RecordCustomCopyCtor/ValueWithId.cs#L3-L10)
* [Listing 41. Opcjonalna zmiana konstruktorów](Typy/Constructors/Chaining/ItemWithId.cs#L3-L24)
* [Listing 42. Przekazywanie argumentów w sekwencji wywoływanych konstruktorów](Typy/Constructors/MoreChaining/ItemWithId.cs#L9-L23)
* [Listing 43. Klasa z konstruktorem statycznym](Typy/Constructors/Static/Bar.cs#L3-L11)
* [Listing 44. Sytuacja, gdy kolejność inicjalizatorów ma znaczenie](Typy/Constructors/Static/StaticFieldOrder.cs#L5-L7)
* [Listing 45. Kolejność inicjalizacji](Typy/InitializationOrder/Program.cs#L3-L43)
* [Listing 46. Cykliczne odwołanie statyczne](Typy/InitializationOrderWithCircularDependencies/Program.cs#L3-L27)

### Dekonstruktory

* [Listing 47. Włączanie dekonstrukcji](Typy/Deconstruction/Size.cs#L3-L19)
* [Listing 48. Zastosowanie niestandardowej dekonstrukcji](Typy/Deconstruction/Program.cs#L3-L7)
* [Listing 49. Wzorzec pozycyjny z wykorzystaniem niestandardowej dekonstrukcji](Typy/Deconstruction/Program.cs#L9-L15)
* [Listing 50. Wzorzec pozycyjny z jawnym określeniem typu](Typy/Deconstruction/Program.cs#L17-L24)
* [Listing 51. Typ record struct korzystający ze składni pozycyjnej](Typy/Deconstruction/Records/Size.cs#L3)

### Metody

* [Listing 52. Zwracanie wielu wartości przy wykorzystaniu słowa kluczowego out](Typy/Methods/Program.cs#L37-L41)
* [Listing 53. Wywołanie metody z parametrem wyjściowym](Typy/Methods/Program.cs#L9)
* [Listing 54. Zastosowanie wyniku parametru wyjściowego w tym samym wyrażeniu](Typy/Methods/Program.cs#L14)
* [Listing 55. Zapis wyniku parametru wyjściowego w istniejącej zmiennej](Typy/Methods/Program.cs#L45-L49)
* [Listing 56. Pomijanie wyniku zwróconego przez parametr wyjściowy](Typy/Methods/Program.cs#L54)
* [Listing 57. Wywoływanie metody z argumentem ref](Typy/Methods/Program.cs#L61-L62)
* [Listing 58. Bardzo duży typ wartościowy](Typy/Methods/Rect.cs#L3)
* [Listing 59. Metoda z parametrem wejściowym](Typy/Methods/Program.cs#L66)
* [Listing 60. Wywoływanie metody z parametrem wejściowym](Typy/Methods/Program.cs#L70-L72)
* [Listing 61. Lokalna zmienna referencyjna](Typy/Methods/Program.cs#L22-L25)
* [Listing 62. Prawidłowe i nieprawidłowe przykłady zwracania referencji jako wyniku](Typy/Methods/Referable.cs#L5-L32)
* [Listing 63. Metoda z argumentami opcjonalnymi](Typy/Methods/Program.cs#L75-L80)
* [Listing 64. Pominięcie jednego argumentu](Typy/Methods/Program.cs#L27)
* [Listing 65. Określanie nazwy podawanego argumentu](Typy/Methods/Program.cs#L28)
* [Listing 66. Argumenty o niejasnym znaczeniu](Typy/Methods/Program.cs#L84-L85)
* [Listing 67. Poprawa przejrzystości kodu poprzez podanie nazw argumentów](Typy/Methods/Program.cs#L91-L93)
* [Listing 68. Przeciążanie metod](Typy/Methods/Overloads.cs#L5-L18)
* [Listing 69. Formatowanie łańcuchów znaków](Typy/Methods/Program.cs#L111-L113)
* [Listing 70. Jawne przekazywanie wielu argumentów w formie tablicy](Typy/Methods/Program.cs#L115-L117)
* [Listing 71. Słowo kluczowe params](Typy/Methods/Program.cs#L121)
* [Listing 72. Funkcje lokalne](Typy/Methods/Program.cs#L124-L146)
* [Listing 73. Funkcje, których ciałem jest wyrażenie](Typy/Methods/Program.cs#L159-L160)
* [Listing 74. Metoda rozszerzenia](Typy/ExtensionMethods/StringExtensions.cs)
* [Listing 75. Metoda rozszerzenia dostępna dzięki użyciu odpowiedniej deklaracji przestrzeni nazw](Typy/ExtensionMethods/Showy.cs)
* [Listing 76. Metoda rozszerzenia dostępna dzięki użyciu odpowiedniej dyrektywy using](Typy/ExtensionMethods/Other/Vocal.cs)

### Właściwości

* [Listing 77. Klasa definiująca prostą właściwość](Typy/Properties/Simple/HasProperty.cs#L3-L17)
* [Listing 78. Akcesory get i set zapisane w formie wyrażeń](Typy/Properties/ExpressionBodied/HasProperty.cs#L3-L11)
* [Listing 79. Właściwość automatyczna](Typy/Properties/Auto/HasProperty.cs#L3-L6)
* [Listing 80. Stosowanie właściwości](Typy/Properties/Program.cs#L3-L6)
* [Listing 81. Właściwość automatyczna z prywatnym akcesorem set](Typy/Properties/Auto/WithPrivateSetter.cs#L10)
* [Listing 82. Właściwość automatyczna bez akcesora set](Typy/Properties/Auto/NoSetter.cs#L10)
* [Listing 83. Inicjalizacja właściwości automatycznej bez akcesora set](Typy/Properties/Auto/WithAutos.cs#L3-L15)
* [Listing 84. Rekord wymagający wartości początkowych lecz zapewniający możliwość póź-niejszej modyfikacji](Typy/Properties/Records/EnforcedInitButMutable.cs#L3-L7)
* [Listing 85. Klasa z właściwością automatyczną z akcesorem set dostępnym wyłącznie pod-czas inicjalizacji](Typy/Properties/Auto/WithInit.cs#L3-L6)
* [Listing 86. Ustawianie wartości właściwości tylko do odczytu](Typy/Properties/Program.cs#L8-L11)
* [Listing 87. Struktura tylko do odczytu z właściwościami modyfikowalnymi tylko podczas ini-cjalizacji](Typy/Properties/Auto/Point.cs#L3-L13)
* [Listing 88. Użycie składni with z typem readonly struct](Typy/Properties/Program.cs#L14-L15)
* [Listing 89. Właściwość obliczana](Typy/Properties/Simple/Calculated.cs#L9-L15)
* [Listing 90. Właściwość tylko do odczytu, której ciałem jest wyrażenie](Typy/Properties/ExpressionBodied/Calculated.cs#L9)
* [Listing 91. Właściwość zmiennego typu wartościowego](Typy/Properties/Mutable/Item.cs#L3-L8)
* [Listing 92. Błąd: używając właściwości, nie można zmodyfikować właściwości typu wartościowego](Typy/Properties/Mutable/UseItem.cs#L12-L13)
* [Listing 93. Zastąpienie właściwości metodami](Typy/Properties/MethodsInstead/Item.cs#L3-L16)
* [Listing 94. Właściwość zwracająca referencję](Typy/Properties/ByRef/Item.cs#L3-L10)
* [Listing 95. Jawne utworzenie kopii](Typy/Properties/Mutable/UseItem.cs#L19-L21)
* [Listing 96. Jawne utworzenie referencji](Typy/Properties/ByRef/UseItem.cs#L9-L11)

### Indeksatory

* [Listing 97. Stosowanie indeksatora](Typy/Indexers/Program.cs#L1-L3)
* [Listing 98. Klasa z indeksatorem](Typy/Indexers/Indexed.cs#L3-L9)
* [Listing 99. Operator warunkowy wartości pustej zastosowany w indeksatorze](Typy/Indexers/Program.cs#L10)
* [Listing 100. Kod odpowiadający użyciu operatora warunkowego wartości pustej z indeksatorem](Typy/Indexers/Program.cs#L17)

### Składnia inicjalizatorów

* [Listing 101. Stosowanie inicjalizatora obiektu](Typy/Initializers/Program.cs#L3-L8)
* [Listing 102. Stosowanie konstruktora i inicjalizatora obiektu](Typy/Initializers/Program.cs#L10-L14)
* [Listing 103. Użycie indeksatora w inicjalizatorze obiektu](Typy/Initializers/Program.cs#L16-L21)

### Operatory

* [Listing 104. Implementacja operatora +](Typy/Operators/Counter.cs#L13-L16)
* [Listing 105. Obsługa operandów innych typów](Typy/Operators/Counter.cs#L18-L26)
* [Listing 106. Operatory konwersji](Typy/Operators/Counter.cs#L28-L36)
* [Listing 107. Stosowanie jawnych operatorów konwersji](Typy/Operators/Program.cs#L3-L4)

### Typy zagnieżdżone

* [Listing 108. Prywatna klasa zagnieżdżona](Typy/NestedTypes/FileSorter.cs#L3-L23)

## Interfejsy

* [Listing 109. Interfejs](Typy/Interfaces/IDoStuff.cs#L3-L10)
* [Listing 110. Implementacja interfejsu](Typy/Interfaces/DoStuff.cs#L3-L6)
* [Listing 111. Jawna implementacja interfejsu](Typy/Interfaces/DoStuff.cs#L8-L11)
* [Listing 112. Interfejs zawierający domyślną implementację metody](Typy/Interfaces/INamed.cs#L3-L7)
* [Listing 113. Interfejs zawierający stałą i typ wyliczeniowy](Typy/Interfaces/IContainMultitudes.cs#L3-L17)

## Typy wyliczeniowe

* [Listing 114. Typ wyliczeniowy definiujący wzajemnie wykluczające się opcje](Typy/Enums/PorridgeTemperature.cs#L3-L8)
* [Listing 115. Instrukcja switch korzystająca ze składowych typu wyliczeniowego](Typy/Enums/Program.cs#L5-L18)
* [Listing 116. Jawnie podane wartości typu wyliczeniowego](Typy/Enums/Ingredients.cs#L3-L14)
* [Listing 117. 64-bitowy typ wyliczeniowy](Typy/Enums/TooManyChoices.cs#L3-L7)
* [Listing 118. Mało pomocne zastosowanie wartości typu bool](Typy/Enums/Program.cs#L37)
* [Listing 119. Łatwość zrozumienia kodu dzięki użyciu typu wyliczeniowego](Typy/Enums/Program.cs#L39)

## Inne typy

* [Listing 120. Typ anonimowy](Typy/AnonymousTypes/Program.cs)