# Rozdział 15. - Przykłady

Przykłady z rozdziału 15. (Pliki i strumienie) książki C# 10.0. Programowanie

## Klasa Stream

* [Listing 1. Najważniejsze składowe klasy Stream](PlikiIStrumienie/Streams/Program.cs#L35-L37)
* [Listing 2. Odczyt zadanej liczby bajtów](PlikiIStrumienie/Streams/Program.cs#L9-L29)
* [Listing 3. Metoda Seek](PlikiIStrumienie/Streams/Program.cs#L39)

## Dostęp swobodny

* [Listing 4. Odczyt danych z pliku przy użyciu klasy RandomAccess](PlikiIStrumienie/RandomFileAccess/Program.cs#L8-L27)

## Typy operujące na tekstach

* [Listing 5. Metody klasy TextReader odczytujące bloki znaków](PlikiIStrumienie/Text/Program.cs#L29-L30)
* [Listing 6. Zapis tekstu do pliku przy użyciu klasy StreamWriter](PlikiIStrumienie/Text/Program.cs#L4-L7)
* [Listing 7. Opakowanie łańcucha znaków przez obiekt StringReader](PlikiIStrumienie/Text/Program.cs#L9-L18)
* [Listing 8. Zapis tekstu przy użyciu strony kodowej Windows 1252](PlikiIStrumienie/Text/Program.cs#L20-L24)

## Pliki i katalogi

* [Listing 9. Konstruktory klasy FileStream umożliwiające podanie ścieżki dostępu do pliku](PlikiIStrumienie/FilesAndDirectories/Program.cs#L30-L39)
* [Listing 10. Porównanie metody File.Create oraz konstruktora klasy FileStream](PlikiIStrumienie/FilesAndDirectories/Program.cs#L1-L9)
* [Listing 11. Dodawanie tekstu do pliku przy użyciu klasy StreamWriter](PlikiIStrumienie/FilesAndDirectories/Append.cs#L7-L13)
* [Listing 12. Tworzenie obiektu StreamWriter w trybie dopisywania przy użyciu metody File.AppendText](PlikiIStrumienie/FilesAndDirectories/Append.cs#L18-L24)
* [Listing 13. Dopisywanie jednego łańcucha znaków do pliku](PlikiIStrumienie/FilesAndDirectories/Append.cs#L29-L32)
* [Listing 14. Dodawanie do pliku jednego wiesza tekstu](PlikiIStrumienie/FilesAndDirectories/Append.cs#L37-L40)
* [Listing 15. Rekurencyjne poszukiwanie plików określonego typu](PlikiIStrumienie/FilesAndDirectories/Program.cs#L11-L16)
* [Listing 16. Wyświetlanie informacji o pliku przy użyciu obiektu FileInfo](PlikiIStrumienie/FilesAndDirectories/Program.cs#L18-L20)
* [Listing 17. Określanie, gdzie należy zapisać ustawienia](PlikiIStrumienie/FilesAndDirectories/Program.cs#L22-L25)

## Serializacja

* [Listing 18. Prosty model obiektowy umożliwiający użycie biblioteki JSON.NET](PlikiIStrumienie/Serialization/SystemTextJson.cs#L107-L120)
* [Listing 19. Serializacja danych przy użyciu klasy JsonSerializer](PlikiIStrumienie/Serialization/SystemTextJson.cs#L11-L31)
* [Listing 20. Deserializacja danych przy użyciu klasy JsonSerializer](PlikiIStrumienie/Serialization/SystemTextJson.cs#L33)
* [Listing 21. Kontrola postaci danych JSON przy użyciu atrybutu JsonPropertyName](PlikiIStrumienie/Serialization/WithAttributes.cs#L7-L17)
* [Listing 22. Użycie wartości JsonSerializerDefaults by zapisywać nazwy właściwości zgodnie z konwencją camelCase](PlikiIStrumienie/Serialization/SystemTextJson.cs#L75-L81)
* [Listing 23. Typ który może powodować występowanie referencji cyklicznych](PlikiIStrumienie/Serialization/SelfRef.cs#L3-L7)
* [Listing 24. Serializacja typu który może powodować występowanie referencji cyklicznych](PlikiIStrumienie/Serialization/SystemTextJson.cs#L88-L102)
* [Listing 25. Dynamiczne badanie kodu JSON przy użyciu typów JsonDocument i JsonElement](PlikiIStrumienie/Serialization/SystemTextJson.cs#L39-L45)
* [Listing 26. Dynamiczne przeglądanie zawartości tablicy w danych JSON przy użyciu typów JsonDocument oraz JsonElement](PlikiIStrumienie/Serialization/SystemTextJson.cs#L49-L53)
* [Listing 27. Odczyt właściwości JSON przy użyciu typu JsonElement](PlikiIStrumienie/Serialization/SystemTextJson.cs#L56-L65)
* [Listing 28. Modyfikowanie danych JSON przy użyciu klasy JsonNode](PlikiIStrumienie/Serialization/SystemTextJson.cs#L68-L70)
