# Rozdział 14. - Przykłady

Przykłady z rozdziału 14. (Atrybuty) książki C# 10.0. Programowanie

## Stosowanie atrybutów

* [Listing 1. Atrybuty w klasie testu jednostkowego](Atrybuty/ImageManagement.Tests/WhenPropertiesRetrieved.cs)
* [Listing 2. Atrybut z argumentem konstruktora](Atrybuty/ImageManagement.Tests/TestWithAdditionalAttributes.cs#L16-L19)
* [Listing 3. Określanie opcjonalnych ustawień atrybutu przy użyciu właściwości](Atrybuty/ImageManagement.Tests/TestWithAdditionalAttributes.cs#L23-L26)
* [Listing 4. Atrybuty podzespołu umieszczane w pliku AssemblyInfo.cs](Atrybuty/Attributes/AssemblyAttributes.cs#L3-L8)
* [Listing 5. Atrybut modułu](Atrybuty/Attributes/ModuleAttribute.cs)
* [Listing 6. Atrybut pola zdarzenia](Atrybuty/Attributes/ForCompilerGeneratedMembers.cs#L5-L9)
* [Listing 7. Atrybuty metody oraz wartości wynikowej](Atrybuty/Attributes/InteropAttributes.cs#L7-L9)
* [Listing 8. Wyrażenie lambda z atrybutami](Atrybuty/AspNetCoreApp/Program.cs#L62-L64)
* [Listing 9. Typowy przykład generowanego pliku z atrybutami podzespołu](Atrybuty/Attributes/TypicalAssemblyAttributes.cs#L4-L25)
* [Listing 10. Atrybuty określające numer wersji](Atrybuty/Attributes/TypicalAssemblyAttributes.cs#L27-L28)
* [Listing 11. Typowe atrybuty zawierające informacje o podzespole](Atrybuty/Attributes/TypicalAssemblyAttributes.cs#L30-L36)
* [Listing 12. Dodawanie do parametrów metod atrybutów informujących o kodzie wywołującym](Atrybuty/Attributes/CallerInfo.cs#L7-L15)
* [Listing 13. INotifyPropertyChanged](Atrybuty/Attributes/NotifyPropertyChanged.cs#L30-L33)
* [Listing 14. Implementacja interfejsu INotifyPropertyChanged nadająca się do wielokrotnego użycia](Atrybuty/Attributes/NotifyPropertyChanged.cs#L6-L25)
* [Listing 15. Zgłaszanie zdarzenia informującego o zmianie wartości właściwości](Atrybuty/Attributes/MyViewModel.cs#L3-L12)
* [Listing 16. Użycie atrybutu CallerArgumentExpressionAttribute w metodzie ArgumentNul-lException.ThrowIfNull](Atrybuty/CallerExpression/Program.cs#L15-L20)
* [Listing 17. Wywołanie metody korzystającej z atrybutu CallerArgumentExpressionAttribute](Atrybuty/CallerExpression/Program.cs#L1-L8)
* [Listing 18. InternalsVisibleToAttribute](Atrybuty/Attributes/AssemblyAttributes.cs#L10-L11)
* [Listing 19. Atrybuty związane ze współdziałaniem](Atrybuty/Attributes/InteropAttributes.cs#L11-L16)

## Definiowanie i stosowanie atrybutów niestandardowych

* [Listing 20. Typ atrybutu](Atrybuty/CustomAttributes/PluginInformationAttribute.cs#L3-L17)
* [Listing 21. Stosowanie atrybutu ](Atrybuty/CustomAttributes/ReportingPlugin.cs#L6-L9)
* [Listing 22. Określanie wartości opcjonalnej właściwości atrybutu](Atrybuty/CustomAttributes/ReportingPlugin.cs#L11-L15)
* [Listing 23. Interfejs ICustomAttributeProvider](Atrybuty/CustomAttributes/Program.cs#L76-L81)
* [Listing 24. Wyświetlanie informacji o wtyczkach](Atrybuty/CustomAttributes/Program.cs#L6-L26)
* [Listing 25. Pobieranie atrybutów przy użyciu klasy MetadataLoadContext](Atrybuty/CustomAttributes/Program.cs#L35-L63)
