﻿namespace RangeAndIndex;

class Program
{
    static void Main()
    {
        char[] letters = { 'a', 'b', 'c', 'd' };
        char lastLetter = letters[^1];

        int[] numbers = { 1, 2, 3, 4, 5, 6, 7 };
        // pobieramy 4. i 5. element tablicy (lecz nie 3. z powodów, które zaraz zostaną wyjaśnione
        int[] theFourthTheFifth = numbers[3..5];

        Index first = 0;
        Index second = 1;
        Index third = 2;
        var fourth = new Index(3, fromEnd: false);

        Index antePenultimate = ^3;
        Index penultimate = ^2;
        Index last = ^1;
        Index directlyAfterTheLast = ^0;

        int lastOld = numbers[numbers.Length - 1];
        int lastNew = numbers[^1];

        int penultimateOld = numbers[numbers.Length - 2];
        int penultimateNew = numbers[^2];

        Range everything = 0..^0;
        Range alsoEverything = 0..;
        Range everythingAgain = ..^0;
        Range everythingOneMoreTime = ..;
        var yetAnotherWayToSayEverything = Range.All;

        Range firstThreeItems = 0..3;
        Range alsoFirstThreeItems = ..3;

        Range allButTheFirstThree = 3..^0;
        Range alsoAllButTheFirstThree = 3..;

        Range allButTheLastThree = 0..^3;
        Range alsoAllButTheLastThree = ..^3;

        Range lastThreeItems = ^3..^0;
        Range alsoLastThreeItems = ^3..;

        string t1 = "dysfunkcyjny";
        string t2 = t1[3..6];
        Console.WriteLine($"Fragment {t2} łańcucha {t1}");

        Rangeable r1 = new();
        Range r = 2..^2;

        Rangeable r2;

        r2 = r1[r];
        // to odpowiednik:
        int startIndex = r.Start.GetOffset(r1.Length);
        int endIndex = r.End.GetOffset(r1.Length);
        r2 = r1.Slice(startIndex, endIndex - startIndex);
    }

    public static void ArraySegmentSubrange()
    {
        int[] numbers = { 1, 2, 3, 4, 5, 6, 7 };
        ArraySegment<int> wholeArrayAsSegment = numbers;
        ArraySegment<int> theFourthTheFifth = wholeArrayAsSegment[3..5];
    }

    public static void SpanSubrange()
    {
        int[] numbers = { 1, 2, 3, 4, 5, 6, 7 };
        Span<int> wholeArrayAsSpan = numbers;
        Span<int> theFourthTheFifth = wholeArrayAsSpan[3..5];
        ReadOnlySpan<char> textSpan = "dysfunkcyjny".AsSpan();
        ReadOnlySpan<char> such = textSpan[3..6];
    }
}
