﻿namespace Constraints;

// Tylko do celów ilustracyjnych. W rzeczywistych zastosowaniach należy
// rozważyć użycie typu Lazy<T>
public static class Deferred<T>
    where T : new()
{
    private static T? _instance;

    public static T Instance
    {
        get
        {
            if (_instance == null)
            {
                _instance = new T();
            }
            return _instance;
        }
    }
}
