﻿using System.Globalization;

using static System.Console;

WriteLine("Najwcześniejsza wartość daty i czasu to: {0}",
  arg0: DateTime.MinValue);

WriteLine("Wartość daty i czasu epoki uniksowej to: {0}",
  arg0: DateTime.UnixEpoch);

WriteLine("Aktualna wartość daty i czasu to: {0}",
  arg0: DateTime.Now);

WriteLine("Dzisiejsza wartość daty i czasu to: {0}",
  arg0: DateTime.Today);

DateTime bozeNarodzenie = new(year: 2022, month: 12, day: 25);

WriteLine("Boże Narodzenie: {0}",
  arg0: bozeNarodzenie); // domyślny format

WriteLine("Boże Narodzenie: {0:dddd, dd MMMM yyyy}",
  arg0: bozeNarodzenie); // własny format

WriteLine("Boże Narodzenie jest w {0} miesiącu roku.",
  arg0: bozeNarodzenie.Month);

WriteLine("Boże Narodzenie jest w {0} dniu roku.",
  arg0: bozeNarodzenie.DayOfYear);

WriteLine("Boże Narodzenie {0} przypada w {1}.",
  arg0: bozeNarodzenie.Year,
  arg1: bozeNarodzenie.DayOfWeek);

DateTime przedBN = bozeNarodzenie.Subtract(TimeSpan.FromDays(12));
DateTime poBN = bozeNarodzenie.AddDays(12);

WriteLine("12 dni przed Bożym Narodzeniem to: {0}",
  arg0: przedBN);

WriteLine("12 dni po Bożym Narodzeniu to: {0}",
  arg0: poBN);

TimeSpan ileDoSwiat = bozeNarodzenie - DateTime.Now;

WriteLine("Zostało jeszcze {0} dni i {1} godzin do Bożego Narodzenia.",
  arg0: ileDoSwiat.Days,
  arg1: ileDoSwiat.Hours);

WriteLine("Do Bożego Narodzenia zostało jeszcze {0:N0} godzin.",
  arg0: ileDoSwiat.TotalHours);

DateTime otwieraniePrezentow = new(
  year: 2022, month: 12, day: 24,
  hour: 17, minute: 30, second: 0);

WriteLine("Dzieci otwierają prezenty: {0}",
  arg0: otwieraniePrezentow);

WriteLine("Dzieci czekają na godzinę {0}",
  arg0: otwieraniePrezentow.ToShortTimeString());

WriteLine("Bieżąca kultura to: {0}",
  arg0: CultureInfo.CurrentCulture.Name);

string tekstDaty = "4 lipiec 2022";
DateTime dzienNiepodleglosci = DateTime.Parse(tekstDaty);

WriteLine("Tekst: {0}, DateTime: {1:d MMMM}",
  arg0: tekstDaty,
  arg1: dzienNiepodleglosci);

tekstDaty = "7/4/2022";
dzienNiepodleglosci = DateTime.Parse(tekstDaty);

WriteLine("Tekst: {0}, DateTime: {1:d MMMM}",
  arg0: tekstDaty,
  arg1: dzienNiepodleglosci);

dzienNiepodleglosci = DateTime.Parse(tekstDaty,
  provider: CultureInfo.GetCultureInfo("en-US"));

WriteLine("Tekst: {0}, DateTime: {1:d MMMM}",
  arg0: tekstDaty,
  arg1: dzienNiepodleglosci);

for (int rok = 2020; rok < 2026; rok++)
{
   Write($"{rok} jest rokiem przestępnym: {DateTime.IsLeapYear(rok)}. ");
   WriteLine("W lutym {0} roku jest {1} dni.",
     arg0: rok, arg1: DateTime.DaysInMonth(year: rok, month: 2));
}

WriteLine("Boże Narodzenie jest w czasie letnim? {0}",
  arg0: bozeNarodzenie.IsDaylightSavingTime());

WriteLine("Dzień NNiepodległości jest w czasie letnim? {0}",
  arg0: dzienNiepodleglosci.IsDaylightSavingTime());

DateOnly urodzinyKrolowej = new(year: 2022, month: 4, day: 21);
WriteLine($"Następne urodziny królowej są {urodzinyKrolowej}.");

TimeOnly poczatekPrzyjecia = new(hour: 20, minute: 30);
WriteLine($"Przyjęcie urodzinowe królowej zaczyna się o godzinie {poczatekPrzyjecia}.");

DateTime pozycjaWKalendarzu = urodzinyKrolowej.ToDateTime(poczatekPrzyjecia);
WriteLine($"Dodaj do kalendarza: {pozycjaWKalendarzu}.");
