﻿using SixLabors.ImageSharp;
using SixLabors.ImageSharp.Processing;

using static System.Console;

string folderObrazow = Path.Combine(
  Environment.CurrentDirectory, "obrazy");

WriteLine($"Poszukam obrazków w tym folderze:\n{folderObrazow}");
WriteLine();

if (!Directory.Exists(folderObrazow))
{
  WriteLine();
  WriteLine("Folder nie istnieje!");
  return;
}

IEnumerable<string> obrazy =
  Directory.EnumerateFiles(folderObrazow);

foreach (string sciezkaDoObrazu in obrazy)
{
  if (Path.GetFileNameWithoutExtension(sciezkaDoObrazu).EndsWith("-thumbnail"))
  {
    WriteLine($"Pomijam:\n  {sciezkaDoObrazu}");
    WriteLine();
    continue; // ten plik został już przekształcony
  }

  string sciezkaDoMiniatury = Path.Combine(
    Environment.CurrentDirectory, "obrazy",
    Path.GetFileNameWithoutExtension(sciezkaDoObrazu)
    + "-thumbnail" + Path.GetExtension(sciezkaDoObrazu));

  using (Image obraz = Image.Load(sciezkaDoObrazu))
  {
    WriteLine($"Konwersja obrazu:\n  {sciezkaDoObrazu}");
    WriteLine($"Do pliku:\n  {sciezkaDoMiniatury}");
    obraz.Mutate(x => x.Resize(obraz.Width / 10, obraz.Height / 10));
    obraz.Mutate(x => x.Grayscale());
    obraz.Save(sciezkaDoMiniatury);
    WriteLine();
  }
}

WriteLine("Przetwarzanie obrazów zakończone. Możesz je obejrzeć w folderze.");
