﻿using BibliotekaWspolna; // DodajKontekstNorthwind

using static System.Console;

namespace Northwind.Web;

public class Startup
{
  public void ConfigureServices(IServiceCollection serwisy)
  {
    serwisy.AddRazorPages();

    serwisy.DodajKontekstNorthwind();
  }

  public void Configure(
    IApplicationBuilder app, IWebHostEnvironment env)
  {
    if (!env.IsDevelopment())
    {
      app.UseHsts();
    }

    app.UseRouting(); // // uruchamia routing dla punktu końcowego

    app.Use(async (HttpContext kontekst, Func<Task> nastepna) =>
    {
      RouteEndpoint? rep = kontekst.GetEndpoint() as RouteEndpoint;
      if (rep is not null)
      {
        WriteLine($"Nazwa punktu końcowego: {rep.DisplayName}");
        WriteLine($"Wzorzec trasiwania punktu końcowego: {rep.RoutePattern.RawText}");
      }

      if (kontekst.Request.Path == "/bonjour")
      {
        // w przypadku dopasowania ścieżki URL ten delegat zakończy przetwarzanie żądania
        // Po jego wywołaniu nie przechodzimy do żadnego z kolejnych delegatów
        await kontekst.Response.WriteAsync("Bonjour Monde!");
        return;
      }

      // możemy zmodyfikować żądanie przed wywołaniem kolejnego delegata
      await nastepna();
       // możemy zmodyfikować żądanie po wywołaniu kolejnego delegata
    });

    app.UseHttpsRedirection();

    app.UseDefaultFiles(); // index.html, default.html itd.
    app.UseStaticFiles();

    app.UseEndpoints(endpoints =>
    {
      endpoints.MapRazorPages();

      endpoints.MapGet("/witaj", () => "Witaj, świecie!");
    });
  }
}
