// <4. Import CUSTOM_ELEMENTS_SCHEMA> 
import { CUSTOM_ELEMENTS_SCHEMA, NgModule } from '@angular/core';
// </4. Import CUSTOM_ELEMENTS_SCHEMA>
import { BrowserModule } from '@angular/platform-browser';
import { FormsModule } from '@angular/forms';
import { HttpClientModule } from '@angular/common/http';
import { RouterModule } from '@angular/router';

import { AppComponent } from './app.component';
import { NavMenuComponent } from './nav-menu/nav-menu.component';
import { HomeComponent } from './home/home.component';
import { CounterComponent } from './counter/counter.component';
import { FetchDataComponent } from './fetch-data/fetch-data.component';

@NgModule({
  declarations: [
    AppComponent,
    NavMenuComponent,
    HomeComponent,
    CounterComponent,
    FetchDataComponent
  ],
  imports: [
    BrowserModule.withServerTransition({ appId: 'ng-cli-universal' }),
    HttpClientModule,
    FormsModule,
    RouterModule.forRoot([
      { path: '', component: HomeComponent, pathMatch: 'full' },
      { path: 'counter', component: CounterComponent },
      { path: 'fetch-data', component: FetchDataComponent },
    ])
  ],
  providers: [],
  bootstrap: [AppComponent],
  // <5. Add CUSTOM_ELEMENTS_SCHEMA>
  schemas: [
    CUSTOM_ELEMENTS_SCHEMA // Informacja, że szablon zawiera niestandardowe znaczniki
  ]
  // </5. Add CUSTOM_ELEMENTS_SCHEMA>
})
export class AppModule { }
