# -*- coding: utf-8 -*-
import win32gui
import win32ui
import win32con
import win32api

# utworzenie uchwytu do gwnego okna pulpitu
hdesktop = win32gui.GetDesktopWindow()

# sprawdzenie rozmiaru w pikselach wszystkich monitorw
width = win32api.GetSystemMetrics(win32con.SM_CXVIRTUALSCREEN)
height = win32api.GetSystemMetrics(win32con.SM_CYVIRTUALSCREEN)
left = win32api.GetSystemMetrics(win32con.SM_XVIRTUALSCREEN)
top = win32api.GetSystemMetrics(win32con.SM_YVIRTUALSCREEN)

# utworzenie kontekstu urzdzenia
desktop_dc = win32gui.GetWindowDC(hdesktop)
img_dc = win32ui.CreateDCFromHandle(desktop_dc)

# utworzenie kontekstu urzdzenia w pamici
mem_dc = img_dc.CreateCompatibleDC()

# utworzenie obiektu bitmapowego
screenshot = win32ui.CreateBitmap()
screenshot.CreateCompatibleBitmap(img_dc, width, height)
mem_dc.SelectObject(screenshot)

# skopiowanie ekranu do kontekstu urzdzenia w pamici
mem_dc.BitBlt((0, 0), (width, height), img_dc, (left, top), win32con.SRCCOPY)

# zapisanie bitmapy w pliku
screenshot.SaveBitmapFile(mem_dc, 'c:\\WINDOWS\\Temp\\screenshot.bmp')

# zwolnienie obiektw
mem_dc.DeleteDC()
win32gui.DeleteObject(screenshot.GetHandle())