# -*- coding: utf-8 -*-
import socket
import os
import struct
from ctypes import *

# host do nasuchiwania
host   = "192.168.0.187"

class IP(Structure):

    _fields_ = [
        ("ihl",           c_ubyte, 4),
        ("version",       c_ubyte, 4),
        ("tos",           c_ubyte),
        ("len",           c_ushort),
        ("id",            c_ushort),
        ("offset",        c_ushort),
        ("ttl",           c_ubyte),
        ("protocol_num",  c_ubyte),
        ("sum",           c_ushort),
        ("src",           c_ulong),
        ("dst",           c_ulong)
    ]

    def __new__(self, socket_buffer=None):
        return self.from_buffer_copy(socket_buffer)    

    def __init__(self, socket_buffer=None):

        # mapowanie staych protokow na ich nazwy
        self.protocol_map = {1:"ICMP", 6:"TCP", 17:"UDP"}

        # adresy IP czytelne dla czowieka
        self.src_address = socket.inet_ntoa(struct.pack("<L",self.src))
        self.dst_address = socket.inet_ntoa(struct.pack("<L",self.dst))

        # protok czytelny dla czowieka
        try:
            self.protocol = self.protocol_map[self.protocol_num]
        except:
            self.protocol = str(self.protocol_num)

# utworzenie surowego gniazda i zwizanie go z publicznym interfejsem
if os.name == "nt":
    socket_protocol = socket.IPPROTO_IP 
else:
    socket_protocol = socket.IPPROTO_ICMP
    
sniffer = socket.socket(socket.AF_INET, socket.SOCK_RAW, socket_protocol)

sniffer.bind((host, 0))

# chcemy przechwyci te nagwki IP
sniffer.setsockopt(socket.IPPROTO_IP, socket.IP_HDRINCL, 1)

# jeli uywany jest system Windows, musimy wysa kilka wywoa IOCTL,
# aby wczy tryb nieograniczony
if os.name == "nt":
    sniffer.ioctl(socket.SIO_RCVALL, socket.RCVALL_ON)

try:
    while True:
    
        # wczytanie jednego pakietu
        raw_buffer = sniffer.recvfrom(65565)[0]
    
        # utworzenie nagwka IP z 20 pierwszych bajtw z bufora
        ip_header = IP(raw_buffer[0:20])
    
        print "Protok: %s %s -> %s" % (ip_header.protocol, ip_header.src_address, ip_header.dst_address)
        
except KeyboardInterrupt:
    # jeli uywany jest system Windows, wyczamy tryb nieograniczony
    if os.name == "nt":
        sniffer.ioctl(socket.SIO_RCVALL, socket.RCVALL_OFF)
