# -*- coding: utf-8 -*-
import socket
import os

# host do nasuchiwania
host = "192.168.0.196"

# utworzenie surowego gniazda i zwizanie go z publicznym interfejsem
if os.name == "nt":
    socket_protocol = socket.IPPROTO_IP
else:
    socket_protocol = socket.IPPROTO_ICMP

sniffer = socket.socket(socket.AF_INET, socket.SOCK_RAW, socket_protocol) 

sniffer.bind((host, 0))

# chcemy doda nagwki IP
sniffer.setsockopt(socket.IPPROTO_IP, socket.IP_HDRINCL, 1)

# jeli uywany jest system Windows, musimy wysa kilka wywoa IOCTL,
# aby wczy tryb nieograniczony
if os.name == "nt": 
    sniffer.ioctl(socket.SIO_RCVALL, socket.RCVALL_ON)

# wczytanie jednego pakietu
print sniffer.recvfrom(65565)

# jeli uywany jest system Windows, wyczamy tryb nieograniczony
if os.name == "nt": 
    sniffer.ioctl(socket.SIO_RCVALL, socket.RCVALL_OFF)
