/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.math.BigInteger;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.__builtin__;
import org.python.modules.math_erf;
import org.python.modules.math_gamma;

public class math
implements ClassDictInit {
    public static PyFloat pi = new PyFloat(Math.PI);
    public static PyFloat e = new PyFloat(Math.E);
    private static final double ZERO = 0.0;
    private static final double MINUS_ZERO = -0.0;
    private static final double HALF = 0.5;
    private static final double ONE = 1.0;
    private static final double MINUS_ONE = -1.0;
    private static final double TWO = 2.0;
    private static final double EIGHT = 8.0;
    private static final double INF = Double.POSITIVE_INFINITY;
    private static final double NINF = Double.NEGATIVE_INFINITY;
    private static final double NAN = Double.NaN;
    private static final BigInteger MAX_LONG_BIGINTEGER = new BigInteger(String.valueOf(Long.MAX_VALUE));
    private static final BigInteger MIN_LONG_BIGINTEGER = new BigInteger(String.valueOf(Long.MIN_VALUE));

    public static void classDictInit(PyObject dict) {
    }

    public static double gamma(double v) {
        return math_gamma.gamma(v);
    }

    public static double lgamma(double v) {
        return math_gamma.lgamma(v);
    }

    public static double erf(double v) {
        return math_erf.erf(v);
    }

    public static double erfc(double v) {
        return math_erf.erfc(v);
    }

    public static double expm1(double v) {
        if (Double.POSITIVE_INFINITY == v) {
            return v;
        }
        double result = Math.expm1(v);
        if (Double.isInfinite(result)) {
            throw Py.OverflowError(Double.toString(v));
        }
        return result;
    }

    public static double acos(double v) {
        if (math.isinf(v)) {
            math.throwMathDomainValueError();
        }
        if (math.isnan(v)) {
            return v;
        }
        return Math.acos(v);
    }

    public static double acosh(double v) {
        double ln2 = 0.6931471805599453;
        double large = 2.68435456E8;
        if (math.isninf(v)) {
            math.throwMathDomainValueError();
        }
        if (v == 0.0 || v == -1.0) {
            math.throwMathDomainValueError();
        }
        if (math.isnan(v) || math.isinf(v) || v < 1.0) {
            return v;
        }
        if (v == 1.0) {
            return 0.0;
        }
        if (v >= 2.68435456E8) {
            return math.log(v) + 0.6931471805599453;
        }
        return math.log(v + math.sqrt(v * v - 1.0));
    }

    public static double asin(double v) {
        if (math.isinf(v)) {
            math.throwMathDomainValueError();
        }
        if (math.isnan(v)) {
            return v;
        }
        return Math.asin(v);
    }

    public static double asinh(double v) {
        if (math.isnan(v) || math.isinf(v)) {
            return v;
        }
        double ln2 = 0.6931471805599453;
        double large = 2.68435456E8;
        double small = 3.725290298461914E-9;
        boolean sign = false;
        if (v < 0.0) {
            v = -v;
            sign = true;
        }
        double temp = v > 2.68435456E8 ? math.log(v) + 0.6931471805599453 : (v > 2.0 ? math.log(2.0 * v + 1.0 / (math.sqrt(v * v + 1.0) + v)) : (v < 3.725290298461914E-9 ? v : math.log1p(v + v * v / (1.0 + math.sqrt(1.0 + v * v)))));
        return sign ? -temp : temp;
    }

    public static double atan(double v) {
        if (math.isnan(v)) {
            return v;
        }
        return Math.atan(v);
    }

    public static double atanh(double v) {
        if (math.isnan(v)) {
            return v;
        }
        if (math.isinf(v) || Math.abs(v) == 1.0) {
            math.throwMathDomainValueError();
        }
        return math.log((1.0 + v) / (1.0 - v)) / 2.0;
    }

    public static double atan2(double v, double w) {
        return Math.atan2(v, w);
    }

    public static double ceil(PyObject v) {
        return math.ceil(v.asDouble());
    }

    public static double ceil(double v) {
        if (math.isnan(v) || math.isinf(v)) {
            return v;
        }
        return Math.ceil(v);
    }

    public static double cos(double v) {
        if (math.isinf(v)) {
            math.throwMathDomainValueError();
        }
        if (math.isnan(v)) {
            return Double.NaN;
        }
        return Math.cos(v);
    }

    public static double cosh(double v) {
        if (math.isinf(v)) {
            return Double.POSITIVE_INFINITY;
        }
        if (math.isnan(v)) {
            return v;
        }
        return 0.5 * (Math.exp(v) + Math.exp(-v));
    }

    public static double exp(double v) {
        if (math.isninf(v)) {
            return 0.0;
        }
        if (math.isnan(v) || math.isinf(v)) {
            return v;
        }
        return math.check(Math.exp(v));
    }

    public static double floor(PyObject v) {
        return math.floor(v.asDouble());
    }

    public static double floor(double v) {
        if (math.isnan(v) || math.isinf(v)) {
            return v;
        }
        return Math.floor(v);
    }

    public static double log(PyObject v) {
        return math.log(v, null);
    }

    public static double log(PyObject v, PyObject base) {
        double doubleValue = v instanceof PyLong ? math.calculateLongLog((PyLong)v) : math.log(v.asDouble());
        if (base != null) {
            return math.check(math.applyLoggedBase(doubleValue, base));
        }
        return doubleValue;
    }

    public static double pow(double v, double w) {
        if (w == 0.0) {
            return 1.0;
        }
        if (v == 1.0) {
            return v;
        }
        if (math.isnan(v) || math.isnan(w)) {
            return Double.NaN;
        }
        if (v == 0.0) {
            if (w == 0.0) {
                return 1.0;
            }
            if (w > 0.0 || math.ispinf(w)) {
                return 0.0;
            }
            math.throwMathDomainValueError();
        }
        if (math.isninf(v)) {
            if (math.isninf(w)) {
                return 0.0;
            }
            if (math.isinf(w)) {
                return Double.POSITIVE_INFINITY;
            }
            if (w == 0.0) {
                return 1.0;
            }
            if (w > 0.0) {
                if (math.isOdd(w)) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.POSITIVE_INFINITY;
            }
            if (math.isOdd(w)) {
                return -0.0;
            }
            return 0.0;
        }
        if (math.isninf(w) && v < 0.0) {
            if (v == -1.0) {
                return 1.0;
            }
            if (v < -1.0) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (math.ispinf(w) && v < 0.0) {
            if (v == -1.0) {
                return 1.0;
            }
            if (v < -1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        if (v < 0.0 && !math.isIntegral(w)) {
            math.throwMathDomainValueError();
        }
        return Math.pow(v, w);
    }

    public static double sin(PyObject v) {
        return math.sin(v.asDouble());
    }

    public static double sin(double v) {
        if (math.isinf(v)) {
            math.throwMathDomainValueError();
        }
        if (math.isnan(v)) {
            return v;
        }
        return Math.sin(v);
    }

    public static double sqrt(PyObject v) {
        return math.sqrt(v.asDouble());
    }

    public static double sqrt(double v) {
        if (math.isnan(v)) {
            return v;
        }
        if (math.ispinf(v)) {
            return v;
        }
        if (math.isninf(v) || v == -1.0) {
            math.throwMathDomainValueError();
        }
        return Math.sqrt(v);
    }

    public static double tan(double v) {
        if (math.isnan(v)) {
            return Double.NaN;
        }
        if (math.isinf(v)) {
            throw Py.ValueError("math domain error");
        }
        return Math.tan(v);
    }

    public static double log10(PyObject v) {
        if (v instanceof PyLong) {
            int[] exp = new int[1];
            double x = ((PyLong)v).scaledDoubleValue(exp);
            if (x <= 0.0) {
                math.throwMathDomainValueError();
            }
            return math.log10(x) + (double)exp[0] * 8.0 * math.log10(2.0);
        }
        return math.log10(v.asDouble());
    }

    public static double sinh(double v) {
        if (math.isnan(v)) {
            return v;
        }
        if (math.isinf(v)) {
            return v;
        }
        return 0.5 * (Math.exp(v) - Math.exp(-v));
    }

    public static double tanh(double v) {
        if (math.isnan(v)) {
            return v;
        }
        if (math.isinf(v)) {
            if (math.isninf(v)) {
                return -1.0;
            }
            return 1.0;
        }
        if (v == -0.0) {
            return v;
        }
        return math.sinh(v) / math.cosh(v);
    }

    public static double fabs(double v) {
        return Math.abs(v);
    }

    public static double fmod(double v, double w) {
        if (math.isnan(v) || math.isnan(w)) {
            return Double.NaN;
        }
        if (math.isinf(w)) {
            return v;
        }
        if (w == 0.0) {
            math.throwMathDomainValueError();
        }
        if (math.isinf(v) && w == 1.0) {
            math.throwMathDomainValueError();
        }
        return v % w;
    }

    public static PyTuple modf(double v) {
        if (math.isnan(v)) {
            return new PyTuple(new PyFloat(v), new PyFloat(v));
        }
        if (math.isinf(v)) {
            double first = 0.0;
            if (math.isninf(v)) {
                first = -0.0;
            }
            return new PyTuple(new PyFloat(first), new PyFloat(v));
        }
        double w = v % 1.0;
        return new PyTuple(new PyFloat(w), new PyFloat(v -= w));
    }

    public static PyTuple frexp(double x) {
        int exponent = 0;
        if (math.isnan(x) || math.isinf(x) || x == 0.0) {
            exponent = 0;
        } else {
            int sign = 1;
            if (x < 0.0) {
                x = -x;
                sign = -1;
            }
            while (x < 0.5) {
                x *= 2.0;
                --exponent;
            }
            while (x >= 1.0) {
                x *= 0.5;
                ++exponent;
            }
            x *= (double)sign;
        }
        return new PyTuple(new PyFloat(x), new PyInteger(exponent));
    }

    public static PyObject trunc(PyObject number) {
        return number.__getattr__("__trunc__").__call__();
    }

    public static double ldexp(double v, PyObject wObj) {
        if (0.0 == v) {
            return v;
        }
        if (math.isinf(v)) {
            return v;
        }
        if (math.isnan(v)) {
            return v;
        }
        long w = math.getLong(wObj);
        if (w == Long.MIN_VALUE) {
            if (v > 0.0) {
                return 0.0;
            }
            return -0.0;
        }
        return math.checkOverflow(v * Math.pow(2.0, w));
    }

    public static double hypot(double v, double w) {
        if (math.isinf(v) || math.isinf(w)) {
            return Double.POSITIVE_INFINITY;
        }
        if (math.isnan(v) || math.isnan(w)) {
            return Double.NaN;
        }
        return Math.hypot(v, w);
    }

    public static double radians(double v) {
        return math.check(Math.toRadians(v));
    }

    public static double degrees(double v) {
        return math.check(Math.toDegrees(v));
    }

    public static boolean isnan(double v) {
        return Double.isNaN(v);
    }

    public static boolean isinf(double v) {
        return Double.isInfinite(v);
    }

    public static double copysign(double v, double w) {
        if (math.isnan(v)) {
            return Double.NaN;
        }
        if (math.signum(v) == math.signum(w)) {
            return v;
        }
        return v *= -1.0;
    }

    public static PyLong factorial(double v) {
        if (v == 0.0 || v == 1.0) {
            return new PyLong(1L);
        }
        if (v < 0.0 || math.isnan(v) || math.isinf(v)) {
            math.throwMathDomainValueError();
        }
        if (!math.isIntegral(v)) {
            math.throwMathDomainValueError();
        }
        long value = (long)v;
        BigInteger bi = new BigInteger(Long.toString(value));
        for (long l = value - 1L; l > 1L; --l) {
            bi = bi.multiply(new BigInteger(Long.toString(l)));
        }
        return new PyLong(bi);
    }

    public static double log1p(double v) {
        return math.log(1.0 + v);
    }

    public static double fsum(PyObject iterable) {
        PyFloat result = (PyFloat)__builtin__.__import__("_fsum").invoke("fsum", iterable);
        return result.asDouble();
    }

    private static double calculateLongLog(PyLong v) {
        int[] exp = new int[1];
        double x = v.scaledDoubleValue(exp);
        if (x <= 0.0) {
            math.throwMathDomainValueError();
        }
        return math.log(x) + (double)exp[0] * 8.0 * math.log(2.0);
    }

    private static double applyLoggedBase(double loggedValue, PyObject base) {
        double loggedBase = base instanceof PyLong ? math.calculateLongLog((PyLong)base) : math.log(base.asDouble());
        return math.check(loggedValue / loggedBase);
    }

    private static double log(double v) {
        if (math.isninf(v)) {
            math.throwMathDomainValueError();
        }
        if (math.isinf(v) || math.isnan(v)) {
            return v;
        }
        return Math.log(v);
    }

    private static double log10(double v) {
        if (math.isninf(v)) {
            math.throwMathDomainValueError();
        }
        if (math.isinf(v) || math.isnan(v)) {
            return v;
        }
        return Math.log10(v);
    }

    private static boolean isninf(double v) {
        return v == Double.NEGATIVE_INFINITY;
    }

    private static boolean ispinf(double v) {
        return v == Double.POSITIVE_INFINITY;
    }

    private static double signum(double v) {
        double signum = 1.0;
        if (v == 0.0) {
            if ('-' == Double.toString(v).charAt(0)) {
                signum = -1.0;
            }
        } else {
            signum = Math.signum(v);
        }
        return signum;
    }

    private static void throwMathDomainValueError() {
        throw Py.ValueError("math domain error");
    }

    private static double check(double v) {
        if (math.isnan(v)) {
            math.throwMathDomainValueError();
        }
        if (math.isinf(v)) {
            throw Py.OverflowError("math range error");
        }
        return v;
    }

    private static double checkOverflow(double v) {
        if (math.isinf(v)) {
            throw Py.OverflowError("math range error");
        }
        return v;
    }

    private static long getLong(PyObject pyo) {
        if (pyo instanceof PyLong) {
            return math.getLong((PyLong)pyo);
        }
        return pyo.asLong();
    }

    private static long getLong(PyLong pyLong) {
        BigInteger value = pyLong.getValue();
        if (value.compareTo(MAX_LONG_BIGINTEGER) > 0) {
            return Long.MAX_VALUE;
        }
        if (value.compareTo(MIN_LONG_BIGINTEGER) < 0) {
            return Long.MIN_VALUE;
        }
        return value.longValue();
    }

    private static boolean isIntegral(double v) {
        return math.ceil(v) - v == 0.0;
    }

    private static boolean isOdd(double v) {
        return math.isIntegral(v) && v % 2.0 != 0.0;
    }
}

