/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.hash;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.python.google.common.base.Preconditions;
import org.python.google.common.hash.AbstractStreamingHashFunction;
import org.python.google.common.hash.Funnel;
import org.python.google.common.hash.HashCode;
import org.python.google.common.hash.HashCodes;
import org.python.google.common.hash.Hasher;

final class MessageDigestHashFunction
extends AbstractStreamingHashFunction {
    private final String algorithmName;
    private final int bits;

    MessageDigestHashFunction(String algorithmName) {
        this.algorithmName = algorithmName;
        this.bits = MessageDigestHashFunction.getMessageDigest(algorithmName).getDigestLength() * 8;
    }

    @Override
    public int bits() {
        return this.bits;
    }

    private static MessageDigest getMessageDigest(String algorithmName) {
        try {
            return MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Hasher newHasher() {
        return new MessageDigestHasher(MessageDigestHashFunction.getMessageDigest(this.algorithmName));
    }

    private static class MessageDigestHasher
    implements Hasher {
        private final MessageDigest digest;
        private final ByteBuffer scratch;
        private boolean done;

        private MessageDigestHasher(MessageDigest digest) {
            this.digest = digest;
            this.scratch = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        }

        @Override
        public Hasher putByte(byte b) {
            this.checkNotDone();
            this.digest.update(b);
            return this;
        }

        @Override
        public Hasher putBytes(byte[] bytes) {
            this.checkNotDone();
            this.digest.update(bytes);
            return this;
        }

        @Override
        public Hasher putBytes(byte[] bytes, int off, int len) {
            this.checkNotDone();
            Preconditions.checkPositionIndexes(off, off + len, bytes.length);
            this.digest.update(bytes, off, len);
            return this;
        }

        @Override
        public Hasher putShort(short s) {
            this.checkNotDone();
            this.scratch.putShort(s);
            this.digest.update(this.scratch.array(), 0, 2);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putInt(int i) {
            this.checkNotDone();
            this.scratch.putInt(i);
            this.digest.update(this.scratch.array(), 0, 4);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putLong(long l) {
            this.checkNotDone();
            this.scratch.putLong(l);
            this.digest.update(this.scratch.array(), 0, 8);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putFloat(float f) {
            this.checkNotDone();
            this.scratch.putFloat(f);
            this.digest.update(this.scratch.array(), 0, 4);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putDouble(double d) {
            this.checkNotDone();
            this.scratch.putDouble(d);
            this.digest.update(this.scratch.array(), 0, 8);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putBoolean(boolean b) {
            return this.putByte(b ? (byte)1 : 0);
        }

        @Override
        public Hasher putChar(char c) {
            this.checkNotDone();
            this.scratch.putChar(c);
            this.digest.update(this.scratch.array(), 0, 2);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putString(CharSequence charSequence) {
            for (int i = 0; i < charSequence.length(); ++i) {
                this.putChar(charSequence.charAt(i));
            }
            return this;
        }

        @Override
        public Hasher putString(CharSequence charSequence, Charset charset) {
            return this.putBytes(((Object)charSequence).toString().getBytes(charset));
        }

        @Override
        public <T> Hasher putObject(T instance, Funnel<? super T> funnel) {
            this.checkNotDone();
            funnel.funnel(instance, this);
            return this;
        }

        private void checkNotDone() {
            Preconditions.checkState(!this.done, "Cannot use Hasher after calling #hash() on it");
        }

        @Override
        public HashCode hash() {
            this.done = true;
            return HashCodes.fromBytesNoCopy(this.digest.digest());
        }
    }
}

