/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.stringlib;

import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.stringlib.MarkupIterator$PyExposer;
import org.python.expose.ExposedType;

@ExposedType(name="formatteriterator", base=PyObject.class, isBaseType=false)
public class MarkupIterator
extends PyObject {
    public static final PyType TYPE;
    private final String markup;
    private int index;
    private final FieldNumbering numbering;

    public MarkupIterator(String markup) {
        this(markup, null);
    }

    public MarkupIterator(String markup, MarkupIterator enclosingIterator) {
        this.markup = markup;
        this.numbering = enclosingIterator != null ? enclosingIterator.numbering : new FieldNumbering();
    }

    @Override
    public PyObject __iter__() {
        return this.formatteriterator___iter__();
    }

    final PyObject formatteriterator___iter__() {
        return this;
    }

    @Override
    public PyObject __iternext__() {
        return this.formatteriterator___iternext__();
    }

    final PyObject formatteriterator___iternext__() {
        Chunk chunk;
        try {
            chunk = this.nextChunk();
        }
        catch (IllegalArgumentException e) {
            throw Py.ValueError(e.getMessage());
        }
        if (chunk == null) {
            return null;
        }
        PyObject[] elements = new PyObject[4];
        elements[0] = new PyString(chunk.literalText);
        PyObject pyObject = elements[1] = chunk.fieldName.length() == 0 ? Py.None : new PyString(chunk.fieldName);
        elements[2] = chunk.fieldName.length() > 0 ? (chunk.formatSpec == null ? Py.EmptyString : new PyString(chunk.formatSpec)) : Py.None;
        elements[3] = chunk.conversion == null ? Py.None : new PyString(chunk.conversion);
        return new PyTuple(elements);
    }

    public Chunk nextChunk() {
        if (this.index == this.markup.length()) {
            return null;
        }
        Chunk result = new Chunk();
        int pos = this.index;
        while ((pos = this.indexOfFirst(this.markup, pos, '{', '}')) >= 0 && pos < this.markup.length() - 1 && this.markup.charAt(pos + 1) == this.markup.charAt(pos)) {
            pos += 2;
        }
        if (pos >= 0 && this.markup.charAt(pos) == '}') {
            throw new IllegalArgumentException("Single '}' encountered in format string");
        }
        if (pos < 0) {
            result.literalText = this.unescapeBraces(this.markup.substring(this.index));
            result.fieldName = "";
            this.index = this.markup.length();
        } else {
            result.literalText = this.unescapeBraces(this.markup.substring(this.index, pos));
            int fieldStart = ++pos;
            int count2 = 1;
            while (pos < this.markup.length()) {
                if (this.markup.charAt(pos) == '{') {
                    ++count2;
                    result.formatSpecNeedsExpanding = true;
                } else if (this.markup.charAt(pos) == '}' && --count2 == 0) {
                    this.parseField(result, this.markup.substring(fieldStart, pos));
                    ++pos;
                    break;
                }
                ++pos;
            }
            if (count2 > 0) {
                throw new IllegalArgumentException("Single '{' encountered in format string");
            }
            this.index = pos;
        }
        return result;
    }

    private String unescapeBraces(String substring) {
        return substring.replace("{{", "{").replace("}}", "}");
    }

    private void parseField(Chunk result, String fieldMarkup) {
        int pos = this.indexOfFirst(fieldMarkup, 0, '!', ':');
        if (pos >= 0) {
            result.fieldName = fieldMarkup.substring(0, pos);
            if (fieldMarkup.charAt(pos) == '!') {
                if (pos == fieldMarkup.length() - 1) {
                    throw new IllegalArgumentException("end of format while looking for conversion specifier");
                }
                result.conversion = fieldMarkup.substring(pos + 1, pos + 2);
                if ((pos += 2) < fieldMarkup.length()) {
                    if (fieldMarkup.charAt(pos) != ':') {
                        throw new IllegalArgumentException("expected ':' after conversion specifier");
                    }
                    result.formatSpec = fieldMarkup.substring(pos + 1);
                }
            } else {
                result.formatSpec = fieldMarkup.substring(pos + 1);
            }
        } else {
            result.fieldName = fieldMarkup;
        }
        if (result.fieldName.isEmpty()) {
            result.fieldName = this.numbering.nextAutomaticFieldNumber();
            return;
        }
        char c = result.fieldName.charAt(0);
        if (c == '.' || c == '[') {
            result.fieldName = this.numbering.nextAutomaticFieldNumber() + result.fieldName;
            return;
        }
        if (Character.isDigit(c)) {
            this.numbering.useManualFieldNumbering();
        }
    }

    private int indexOfFirst(String s, int start, char c1, char c2) {
        int i1 = s.indexOf(c1, start);
        int i2 = s.indexOf(c2, start);
        if (i1 == -1) {
            return i2;
        }
        if (i2 == -1) {
            return i1;
        }
        return Math.min(i1, i2);
    }

    static {
        PyType.addBuilder(MarkupIterator.class, new MarkupIterator$PyExposer());
        TYPE = PyType.fromClass(MarkupIterator.class);
    }

    public static final class Chunk {
        public String literalText;
        public String fieldName;
        public String formatSpec;
        public String conversion;
        public boolean formatSpecNeedsExpanding;
    }

    static final class FieldNumbering {
        private boolean manualFieldNumberSpecified;
        private int automaticFieldNumber = 0;

        FieldNumbering() {
        }

        String nextAutomaticFieldNumber() {
            if (this.manualFieldNumberSpecified) {
                throw new IllegalArgumentException("cannot switch from manual field specification to automatic field numbering");
            }
            return Integer.toString(this.automaticFieldNumber++);
        }

        void useManualFieldNumbering() {
            if (this.manualFieldNumberSpecified) {
                return;
            }
            if (this.automaticFieldNumber != 0) {
                throw new IllegalArgumentException("cannot switch from automatic field numbering to manual field specification");
            }
            this.manualFieldNumberSpecified = true;
        }
    }
}

