/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.python.core.ArgParser;
import org.python.core.BaseBytes;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyBuffer;
import org.python.core.PyByteArray$PyExposer;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.buffer.BaseBuffer;
import org.python.core.buffer.SimpleWritableBuffer;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="bytearray", base=PyObject.class, doc="bytearray(iterable_of_ints) -> bytearray.\nbytearray(string, encoding[, errors]) -> bytearray.\nbytearray(bytes_or_bytearray) -> mutable copy of bytes_or_bytearray.\nbytearray(memory_view) -> bytearray.\n\nConstruct an mutable bytearray object from:\n  - an iterable yielding integers in range(256)\n  - a text string encoded using the specified encoding\n  - a bytes or a bytearray object\n  - any object implementing the buffer API.\n\nbytearray(int) -> bytearray.\n\nConstruct a zero-initialized bytearray of the given length.")
public class PyByteArray
extends BaseBytes
implements BufferProtocol {
    public static final PyType TYPE;
    private WeakReference<BaseBuffer> export;

    public PyByteArray(PyType type) {
        super(type);
    }

    public PyByteArray() {
        super(TYPE);
    }

    public PyByteArray(int size) {
        super(TYPE);
        this.init(size);
    }

    public PyByteArray(int[] value) {
        super(TYPE, value);
    }

    public PyByteArray(BaseBytes value) {
        super(TYPE);
        this.init(value);
    }

    PyByteArray(PyBuffer value) {
        super(TYPE);
        this.init(value);
    }

    public PyByteArray(BufferProtocol value) {
        super(TYPE);
        this.init(value);
    }

    public PyByteArray(Iterable<? extends PyObject> value) {
        super(TYPE);
        this.init(value);
    }

    public PyByteArray(PyString arg, PyObject encoding, PyObject errors) {
        super(TYPE);
        this.init(arg, encoding, errors);
    }

    public PyByteArray(PyString arg, String encoding, String errors) {
        super(TYPE);
        this.init(arg, encoding, errors);
    }

    public PyByteArray(PyString arg) {
        super(TYPE);
        this.init(arg, (String)null, (String)null);
    }

    PyByteArray(byte[] storage) {
        super(TYPE);
        this.setStorage(storage);
    }

    PyByteArray(byte[] storage, int size) {
        super(TYPE);
        this.setStorage(storage, size);
    }

    public PyByteArray(PyObject arg) throws PyException {
        super(TYPE);
        this.init(arg);
    }

    @Override
    public synchronized PyBuffer getBuffer(int flags) {
        BaseBuffer pybuf = this.getExistingBuffer(flags);
        if (pybuf == null) {
            pybuf = new SimpleWritableBuffer(flags, this.storage, this.offset, this.size);
            this.export = new WeakReference<BaseBuffer>(pybuf);
        }
        return pybuf;
    }

    private BaseBuffer getExistingBuffer(int flags) throws PyException {
        BaseBuffer pybuf = null;
        if (this.export != null && (pybuf = (BaseBuffer)this.export.get()) != null) {
            pybuf = pybuf.getBufferAgain(flags);
        }
        return pybuf;
    }

    protected void resizeCheck() throws PyException {
        if (this.export != null) {
            PyBuffer pybuf = (PyBuffer)this.export.get();
            if (pybuf != null && !pybuf.isReleased()) {
                throw Py.BufferError("Existing exports of data: object cannot be re-sized");
            }
            this.export = null;
        }
    }

    @Override
    protected synchronized PyByteArray getslice(int start, int stop, int step) {
        if (step == 1) {
            return this.getslice(start, stop);
        }
        int n = PyByteArray.sliceLength(start, stop, step);
        PyByteArray ret = new PyByteArray(n);
        n += ret.offset;
        byte[] dst = ret.storage;
        int io = start + this.offset;
        for (int jo = ret.offset; jo < n; ++jo) {
            dst[jo] = this.storage[io];
            io += step;
        }
        return ret;
    }

    @Override
    protected synchronized PyByteArray getslice(int start, int stop) {
        int n = stop - start;
        if (n <= 0) {
            return new PyByteArray();
        }
        PyByteArray ret = new PyByteArray(n);
        System.arraycopy(this.storage, this.offset + start, ret.storage, ret.offset, n);
        return ret;
    }

    @Override
    protected synchronized PyByteArray repeat(int count2) {
        PyByteArray ret = new PyByteArray();
        ret.setStorage(this.repeatImpl(count2));
        return ret;
    }

    protected synchronized void irepeat(int count2) {
        this.setStorage(this.repeatImpl(count2));
    }

    @Override
    public synchronized void pyset(int index, PyObject value) throws PyException {
        this.storage[index + this.offset] = PyByteArray.byteCheck(value);
    }

    @Override
    public synchronized void pyinsert(int index, PyObject element) {
        this.storageReplace(index, 0, 1);
        this.storage[this.offset + index] = PyByteArray.byteCheck(element);
    }

    @Override
    protected synchronized void setslice(int start, int stop, int step, PyObject value) {
        if (step == 1 && stop < start) {
            stop = start;
        }
        if (value instanceof PyString) {
            this.setslice(start, stop, step, (PyString)value);
        } else if (value.isIndex()) {
            this.setslice(start, stop, step, value.asIndex(Py.OverflowError));
        } else if (value instanceof BaseBytes) {
            this.setslice(start, stop, step, (BaseBytes)value);
        } else if (value instanceof BufferProtocol) {
            this.setslice(start, stop, step, (BufferProtocol)((Object)value));
        } else {
            this.setslice(start, stop, step, value.asIterable());
        }
    }

    private void setslice(int start, int stop, int step, int len) throws PyException {
        if (step == 1) {
            this.storageReplace(start, stop - start, len);
            Arrays.fill(this.storage, start + this.offset, start + this.offset + len, (byte)0);
        } else {
            int n = PyByteArray.sliceLength(start, stop, step);
            if (n != len) {
                throw PyByteArray.SliceSizeError("bytes", len, n);
            }
            int io = start + this.offset;
            while (n > 0) {
                this.storage[io] = 0;
                io += step;
                --n;
            }
        }
    }

    private void setslice(int start, int stop, int step, PyString value) throws PyException {
        String v = value.asString();
        int len = v.length();
        if (step == 1) {
            this.storageReplace(start, stop - start, len);
            this.setBytes(start, v);
        } else {
            int n = PyByteArray.sliceLength(start, stop, step);
            if (n != len) {
                throw PyByteArray.SliceSizeError("bytes", len, n);
            }
            this.setBytes(start, step, v);
        }
    }

    private void setslice(int start, int stop, int step, BufferProtocol value) throws PyException {
        PyBuffer view = value.getBuffer(284);
        int len = view.getLen();
        if (step == 1) {
            this.storageReplace(start, stop - start, len);
            view.copyTo(this.storage, start + this.offset);
        } else {
            int n = PyByteArray.sliceLength(start, stop, step);
            if (n != len) {
                throw PyByteArray.SliceSizeError("bytes", len, n);
            }
            int io = start + this.offset;
            for (int j = 0; j < n; ++j) {
                this.storage[io] = view.byteAt(j);
                io += step;
            }
        }
    }

    private void setslice(int start, int stop, int step, BaseBytes value) throws PyException {
        if (value == this) {
            value = new PyByteArray(value);
        }
        int len = value.size;
        if (step == 1) {
            this.storageReplace(start, stop - start, len);
            System.arraycopy(value.storage, value.offset, this.storage, start + this.offset, len);
        } else {
            int n = PyByteArray.sliceLength(start, stop, step);
            if (n != len) {
                throw PyByteArray.SliceSizeError("bytes", len, n);
            }
            int no = n + value.offset;
            int io = start + this.offset;
            for (int jo = value.offset; jo < no; ++jo) {
                this.storage[io] = value.storage[jo];
                io += step;
            }
        }
    }

    private void setslice(int start, int stop, int step, Iterable<? extends PyObject> iter) {
        BaseBytes.FragmentList fragList = new BaseBytes.FragmentList();
        fragList.loadFrom(iter);
        if (step == 1) {
            this.storageReplace(start, stop - start, fragList.totalCount);
            if (fragList.totalCount > 0) {
                fragList.emptyInto(this.storage, start + this.offset);
            }
        } else {
            int n = PyByteArray.sliceLength(start, stop, step);
            if (n != fragList.totalCount) {
                throw PyByteArray.SliceSizeError("bytes", fragList.totalCount, n);
            }
            fragList.emptyInto(this.storage, start + this.offset, step);
        }
    }

    @Override
    protected synchronized void del(int index) {
        this.storageDelete(index, 1);
    }

    @Override
    protected synchronized void delRange(int start, int stop) {
        this.storageDelete(start, stop - start);
    }

    protected synchronized void delslice(int start, int stop, int step) {
        if (step == 1) {
            this.storageDelete(start, stop - start);
        } else {
            int n = PyByteArray.sliceLength(start, stop, step);
            if (n > 0) {
                if (step > 0) {
                    this.storageDeleteEx(start, step, n);
                } else {
                    this.storageDeleteEx(start + (n - 1) * step + 1, -step, n);
                }
            }
        }
    }

    public static PyException SliceSizeError(String valueType, int valueSize, int sliceSize) {
        String fmt = "attempt to assign %s of size %d to extended slice of size %d";
        return Py.ValueError(String.format(fmt, valueType, valueSize, sliceSize));
    }

    @ExposedNew
    final synchronized void bytearray___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("bytearray", args, kwds, "source", "encoding", "errors");
        PyObject arg = ap.getPyObject(0, null);
        PyObject encoding = ap.getPyObjectByType(1, PyBaseString.TYPE, null);
        PyObject errors = ap.getPyObjectByType(2, PyBaseString.TYPE, null);
        if (encoding != null || errors != null) {
            if (arg == null || !(arg instanceof PyString)) {
                throw Py.TypeError("encoding or errors without sequence argument");
            }
            this.init((PyString)arg, encoding, errors);
        } else {
            this.init(arg);
        }
    }

    @Override
    protected BaseBytes.Builder getBuilder(int capacity) {
        return new BaseBytes.Builder(capacity){

            @Override
            PyByteArray getResult() {
                return new PyByteArray(this.getStorage(), this.getSize());
            }
        };
    }

    @Override
    public PyObject __eq__(PyObject other) {
        return this.basebytes___eq__(other);
    }

    @Override
    public PyObject __ne__(PyObject other) {
        return this.basebytes___ne__(other);
    }

    @Override
    public PyObject __lt__(PyObject other) {
        return this.basebytes___lt__(other);
    }

    @Override
    public PyObject __le__(PyObject other) {
        return this.basebytes___le__(other);
    }

    @Override
    public PyObject __ge__(PyObject other) {
        return this.basebytes___ge__(other);
    }

    @Override
    public PyObject __gt__(PyObject other) {
        return this.basebytes___gt__(other);
    }

    final synchronized PyObject bytearray___eq__(PyObject other) {
        return this.basebytes___eq__(other);
    }

    final synchronized PyObject bytearray___ne__(PyObject other) {
        return this.basebytes___ne__(other);
    }

    final synchronized PyObject bytearray___lt__(PyObject other) {
        return this.basebytes___lt__(other);
    }

    final synchronized PyObject bytearray___le__(PyObject other) {
        return this.basebytes___le__(other);
    }

    final synchronized PyObject bytearray___ge__(PyObject other) {
        return this.basebytes___ge__(other);
    }

    final synchronized PyObject bytearray___gt__(PyObject other) {
        return this.basebytes___gt__(other);
    }

    @Override
    public PyObject __add__(PyObject o) {
        return this.bytearray___add__(o);
    }

    final synchronized PyObject bytearray___add__(PyObject o) {
        PyByteArray sum = null;
        if (o instanceof BaseBytes) {
            BaseBytes ob = (BaseBytes)o;
            sum = new PyByteArray(this.size + ob.size);
            System.arraycopy(this.storage, this.offset, sum.storage, sum.offset, this.size);
            System.arraycopy(ob.storage, ob.offset, sum.storage, sum.offset + this.size, ob.size);
        } else if (o.getType() == PyString.TYPE) {
            PyString os2 = (PyString)o;
            sum = new PyByteArray(this.size + os2.__len__());
            System.arraycopy(this.storage, this.offset, sum.storage, sum.offset, this.size);
            sum.setslice(this.size, sum.size, 1, os2);
        } else {
            throw PyByteArray.ConcatenationTypeError(TYPE, o.getType());
        }
        return sum;
    }

    public int __alloc__() {
        return this.bytearray___alloc__();
    }

    final int bytearray___alloc__() {
        return this.storage.length;
    }

    @Override
    public PyObject __imul__(PyObject n) {
        return this.bytearray___imul__(n);
    }

    final PyObject bytearray___imul__(PyObject n) {
        if (!n.isIndex()) {
            return null;
        }
        this.irepeat(n.asIndex(Py.OverflowError));
        return this;
    }

    @Override
    public PyObject __mul__(PyObject n) {
        return this.bytearray___mul__(n);
    }

    final PyObject bytearray___mul__(PyObject n) {
        if (!n.isIndex()) {
            return null;
        }
        return this.repeat(n.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject n) {
        return this.bytearray___rmul__(n);
    }

    final PyObject bytearray___rmul__(PyObject n) {
        if (!n.isIndex()) {
            return null;
        }
        return this.repeat(n.asIndex(Py.OverflowError));
    }

    public void append(byte element) {
        this.storageExtend(1);
        this.storage[this.offset + this.size - 1] = element;
    }

    public void append(PyObject element) {
        this.bytearray_append(element);
    }

    final synchronized void bytearray_append(PyObject element) {
        this.storageExtend(1);
        this.storage[this.offset + this.size - 1] = PyByteArray.byteCheck(element);
    }

    @Override
    public boolean __contains__(PyObject o) {
        return this.basebytes___contains__(o);
    }

    final boolean bytearray___contains__(PyObject o) {
        return this.basebytes___contains__(o);
    }

    final PyObject bytearray_decode(PyObject[] args, String[] keywords) {
        return this.basebytes_decode(args, keywords);
    }

    public PyByteArray center(int width) {
        return (PyByteArray)this.basebytes_center(width, " ");
    }

    public PyByteArray center(int width, String fillchar) {
        return (PyByteArray)this.basebytes_center(width, fillchar);
    }

    final PyByteArray bytearray_center(int width, String fillchar) {
        return (PyByteArray)this.basebytes_center(width, fillchar);
    }

    public int count(PyObject sub) {
        return this.basebytes_count(sub, null, null);
    }

    public int count(PyObject sub, PyObject start) {
        return this.basebytes_count(sub, start, null);
    }

    public int count(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_count(sub, start, end);
    }

    final int bytearray_count(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_count(sub, start, end);
    }

    public boolean endswith(PyObject suffix) {
        return this.basebytes_starts_or_endswith(suffix, null, null, true);
    }

    public boolean endswith(PyObject suffix, PyObject start) {
        return this.basebytes_starts_or_endswith(suffix, start, null, true);
    }

    public boolean endswith(PyObject suffix, PyObject start, PyObject end) {
        return this.basebytes_starts_or_endswith(suffix, start, end, true);
    }

    final boolean bytearray_endswith(PyObject suffix, PyObject start, PyObject end) {
        return this.basebytes_starts_or_endswith(suffix, start, end, true);
    }

    public PyByteArray expandtabs() {
        return (PyByteArray)this.basebytes_expandtabs(8);
    }

    public PyByteArray expandtabs(int tabsize) {
        return (PyByteArray)this.basebytes_expandtabs(tabsize);
    }

    final PyByteArray bytearray_expandtabs(int tabsize) {
        return (PyByteArray)this.basebytes_expandtabs(tabsize);
    }

    public void extend(PyObject o) {
        this.bytearray_extend(o);
    }

    final synchronized void bytearray_extend(PyObject o) {
        this.setslice(this.size, this.size, 1, o);
    }

    public int find(PyObject sub) {
        return this.basebytes_find(sub, null, null);
    }

    public int find(PyObject sub, PyObject start) {
        return this.basebytes_find(sub, start, null);
    }

    public int find(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_find(sub, start, end);
    }

    final int bytearray_find(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_find(sub, start, end);
    }

    static PyByteArray fromhex(String hex) throws PyException {
        return PyByteArray.bytearray_fromhex(TYPE, hex);
    }

    static PyByteArray bytearray_fromhex(PyType type, String hex) {
        PyByteArray result = new PyByteArray();
        PyByteArray.basebytes_fromhex(result, hex);
        return result;
    }

    final synchronized PyObject bytearray___getitem__(PyObject index) {
        return this.delegator.checkIdxAndGetItem(index);
    }

    @Override
    public PyObject __iadd__(PyObject o) {
        return this.bytearray___iadd__(o);
    }

    final synchronized PyObject bytearray___iadd__(PyObject o) {
        PyType oType = o.getType();
        if (oType == TYPE) {
            this.setslice(this.size, this.size, 1, (BaseBytes)o);
        } else if (oType == PyString.TYPE) {
            this.setslice(this.size, this.size, 1, (PyString)o);
        } else {
            throw PyByteArray.ConcatenationTypeError(oType, TYPE);
        }
        return this;
    }

    public int index(PyObject sub) {
        return this.bytearray_index(sub, null, null);
    }

    public int index(PyObject sub, PyObject start) {
        return this.bytearray_index(sub, start, null);
    }

    @Override
    public int hashCode() {
        return this.bytearray___hash__();
    }

    final int bytearray___hash__() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    public int index(PyObject sub, PyObject start, PyObject end) throws PyException {
        return this.bytearray_index(sub, start, end);
    }

    final int bytearray_index(PyObject sub, PyObject start, PyObject end) {
        int pos = this.basebytes_find(sub, start, end);
        if (pos < 0) {
            throw Py.ValueError("subsection not found");
        }
        return pos;
    }

    public void insert(PyObject index, PyObject value) {
        this.bytearray_insert(index, value);
    }

    final synchronized void bytearray_insert(PyObject index, PyObject value) {
        this.pyinsert(this.boundToSequence(index.asIndex()), value);
    }

    final boolean bytearray_isalnum() {
        return this.basebytes_isalnum();
    }

    final boolean bytearray_isalpha() {
        return this.basebytes_isalpha();
    }

    final boolean bytearray_isdigit() {
        return this.basebytes_isdigit();
    }

    final boolean bytearray_islower() {
        return this.basebytes_islower();
    }

    final boolean bytearray_isspace() {
        return this.basebytes_isspace();
    }

    final boolean bytearray_istitle() {
        return this.basebytes_istitle();
    }

    final boolean bytearray_isupper() {
        return this.basebytes_isupper();
    }

    final PyByteArray bytearray_capitalize() {
        return (PyByteArray)this.basebytes_capitalize();
    }

    final PyByteArray bytearray_lower() {
        return (PyByteArray)this.basebytes_lower();
    }

    final PyByteArray bytearray_swapcase() {
        return (PyByteArray)this.basebytes_swapcase();
    }

    final PyByteArray bytearray_title() {
        return (PyByteArray)this.basebytes_title();
    }

    final PyByteArray bytearray_upper() {
        return (PyByteArray)this.basebytes_upper();
    }

    public PyByteArray join(PyObject iterable) {
        return this.bytearray_join(iterable);
    }

    final PyByteArray bytearray_join(PyObject iterable) {
        return this.basebytes_join(iterable.asIterable());
    }

    final int bytearray___len__() {
        return this.__len__();
    }

    public PyByteArray ljust(int width) {
        return (PyByteArray)this.basebytes_ljust(width, " ");
    }

    public PyByteArray ljust(int width, String fillchar) {
        return (PyByteArray)this.basebytes_ljust(width, fillchar);
    }

    final PyByteArray bytearray_ljust(int width, String fillchar) {
        return (PyByteArray)this.basebytes_ljust(width, fillchar);
    }

    public PyByteArray lstrip() {
        return this.bytearray_lstrip(null);
    }

    public PyByteArray lstrip(PyObject bytes) {
        return this.bytearray_lstrip(bytes);
    }

    final synchronized PyByteArray bytearray_lstrip(PyObject bytes) {
        int left;
        if (bytes == null || bytes == Py.None) {
            left = this.lstripIndex();
        } else {
            BaseBytes.ByteSet byteSet = new BaseBytes.ByteSet(PyByteArray.getViewOrError(bytes));
            left = this.lstripIndex(byteSet);
        }
        return this.getslice(left, this.size);
    }

    final PyTuple bytearray_partition(PyObject sep) {
        return this.basebytes_partition(sep);
    }

    public PyInteger pop() {
        return this.bytearray_pop(-1);
    }

    public PyInteger pop(int i) {
        return this.bytearray_pop(i);
    }

    final synchronized PyInteger bytearray_pop(int i) {
        if (this.size == 0) {
            throw Py.IndexError("pop from empty list");
        }
        if (i < 0) {
            i += this.size;
        }
        return this.remove(i);
    }

    final PyObject bytearray___reduce__() {
        return this.basebytes___reduce__();
    }

    public void remove(PyObject o) throws PyException {
        this.bytearray_remove(o);
    }

    final synchronized void bytearray_remove(PyObject o) {
        byte b = PyByteArray.byteCheck(o);
        int pos = this.index(b);
        if (pos < 0) {
            throw Py.ValueError("value not found in bytearray");
        }
        this.storageDelete(pos, 1);
    }

    public PyByteArray replace(PyObject oldB, PyObject newB) {
        return this.basebytes_replace(oldB, newB, -1);
    }

    public PyByteArray replace(PyObject oldB, PyObject newB, int maxcount) {
        return this.basebytes_replace(oldB, newB, maxcount);
    }

    final PyByteArray bytearray_replace(PyObject oldB, PyObject newB, PyObject count2) {
        int maxcount = count2 == null ? -1 : count2.asInt();
        return this.basebytes_replace(oldB, newB, maxcount);
    }

    public void reverse() {
        this.bytearray_reverse();
    }

    final synchronized void bytearray_reverse() {
        int a = this.offset;
        int b = this.offset + this.size;
        while (--b > a) {
            byte t = this.storage[b];
            this.storage[b] = this.storage[a];
            this.storage[a++] = t;
        }
    }

    public int rfind(PyObject sub) {
        return this.basebytes_rfind(sub, null, null);
    }

    public int rfind(PyObject sub, PyObject start) {
        return this.basebytes_rfind(sub, start, null);
    }

    public int rfind(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_rfind(sub, start, end);
    }

    final int bytearray_rfind(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_rfind(sub, start, end);
    }

    public int rindex(PyObject sub) {
        return this.bytearray_rindex(sub, null, null);
    }

    public int rindex(PyObject sub, PyObject start) {
        return this.bytearray_rindex(sub, start, null);
    }

    public PyByteArray rjust(int width) {
        return (PyByteArray)this.basebytes_rjust(width, " ");
    }

    public PyByteArray rjust(int width, String fillchar) {
        return (PyByteArray)this.basebytes_rjust(width, fillchar);
    }

    final PyByteArray bytearray_rjust(int width, String fillchar) {
        return (PyByteArray)this.basebytes_rjust(width, fillchar);
    }

    public int rindex(PyObject sub, PyObject start, PyObject end) {
        return this.bytearray_rindex(sub, start, end);
    }

    final int bytearray_rindex(PyObject sub, PyObject start, PyObject end) {
        int pos = this.basebytes_rfind(sub, start, end);
        if (pos < 0) {
            throw Py.ValueError("subsection not found");
        }
        return pos;
    }

    final PyTuple bytearray_rpartition(PyObject sep) {
        return this.basebytes_rpartition(sep);
    }

    final PyList bytearray_rsplit(PyObject sep, int maxsplit) {
        return this.basebytes_rsplit(sep, maxsplit);
    }

    public PyByteArray rstrip() {
        return this.bytearray_rstrip(null);
    }

    public PyByteArray rstrip(PyObject bytes) {
        return this.bytearray_rstrip(bytes);
    }

    final synchronized PyByteArray bytearray_rstrip(PyObject bytes) {
        int right;
        if (bytes == null || bytes == Py.None) {
            right = this.rstripIndex();
        } else {
            BaseBytes.ByteSet byteSet = new BaseBytes.ByteSet(PyByteArray.getViewOrError(bytes));
            right = this.rstripIndex(byteSet);
        }
        return this.getslice(0, right);
    }

    final PyList bytearray_split(PyObject sep, int maxsplit) {
        return this.basebytes_split(sep, maxsplit);
    }

    final PyList bytearray_splitlines(boolean keepends) {
        return this.basebytes_splitlines(keepends);
    }

    public boolean startswith(PyObject prefix) {
        return this.basebytes_starts_or_endswith(prefix, null, null, false);
    }

    public boolean startswith(PyObject prefix, PyObject start) {
        return this.basebytes_starts_or_endswith(prefix, start, null, false);
    }

    public boolean startswith(PyObject prefix, PyObject start, PyObject end) {
        return this.basebytes_starts_or_endswith(prefix, start, end, false);
    }

    final boolean bytearray_startswith(PyObject prefix, PyObject start, PyObject end) {
        return this.basebytes_starts_or_endswith(prefix, start, end, false);
    }

    public PyByteArray strip() {
        return this.bytearray_strip(null);
    }

    public PyByteArray strip(PyObject bytes) {
        return this.bytearray_strip(bytes);
    }

    final synchronized PyByteArray bytearray_strip(PyObject bytes) {
        BaseBytes.ByteSet byteSet;
        int left;
        int right = bytes == null || bytes == Py.None ? ((left = this.lstripIndex()) == this.size ? this.size : this.rstripIndex()) : ((left = this.lstripIndex(byteSet = new BaseBytes.ByteSet(PyByteArray.getViewOrError(bytes)))) == this.size ? this.size : this.rstripIndex(byteSet));
        return this.getslice(left, right);
    }

    final synchronized void bytearray___setitem__(PyObject index, PyObject value) {
        this.delegator.checkIdxAndSetItem(index, value);
    }

    @Override
    public String toString() {
        return this.bytearray_repr();
    }

    final synchronized String bytearray_repr() {
        return this.basebytes_repr("bytearray(b", ")");
    }

    @Override
    public PyString __str__() {
        return this.bytearray_str();
    }

    final PyString bytearray_str() {
        return new PyString(this.asString());
    }

    public PyByteArray translate(PyObject table) {
        return this.bytearray_translate(table, null);
    }

    public PyByteArray translate(PyObject table, PyObject deletechars) {
        return this.bytearray_translate(table, deletechars);
    }

    final PyByteArray bytearray_translate(PyObject table, PyObject deletechars) {
        PyBuffer tab = null;
        if (table != null && table != Py.None && (tab = PyByteArray.getViewOrError(table)).getLen() != 256) {
            throw Py.ValueError("translation table must be 256 bytes long");
        }
        PyByteArray result = new PyByteArray();
        if (deletechars != null) {
            BaseBytes.ByteSet del = new BaseBytes.ByteSet(PyByteArray.getViewOrError(deletechars));
            int limit = this.offset + this.size;
            if (tab != null) {
                for (int i = this.offset; i < limit; ++i) {
                    int b = this.storage[i] & 0xFF;
                    if (del.contains(b)) continue;
                    result.append(tab.byteAt(b));
                }
            } else {
                for (int i = this.offset; i < limit; ++i) {
                    int b = this.storage[i] & 0xFF;
                    if (del.contains(b)) continue;
                    result.append((byte)b);
                }
            }
        } else {
            int limit = this.offset + this.size;
            if (tab != null) {
                for (int i = this.offset; i < limit; ++i) {
                    int b = this.storage[i] & 0xFF;
                    result.append(tab.byteAt(b));
                }
            } else {
                result.extend(this);
            }
        }
        return result;
    }

    public PyByteArray zfill(int width) {
        return (PyByteArray)this.basebytes_zfill(width);
    }

    final PyByteArray bytearray_zfill(int width) {
        return (PyByteArray)this.basebytes_zfill(width);
    }

    private final int recLength(int needed) {
        int L = this.storage.length;
        if (needed > L || needed * 2 < L) {
            return PyByteArray.roundUp(needed);
        }
        return L;
    }

    @Override
    protected void newStorage(int needed) {
        if (needed > 0) {
            int L = this.recLength(needed);
            try {
                byte[] s = new byte[L];
                this.setStorage(s, needed, (L - needed) / 2);
            }
            catch (OutOfMemoryError e) {
                throw Py.MemoryError(e.getMessage());
            }
        } else {
            this.setStorage(emptyStorage);
        }
    }

    private void storageReplace(int a, int d, int e) {
        int b = this.size - (a + d);
        int c = e - d;
        if (c == 0) {
            return;
        }
        if (c > 0 && b == 0) {
            this.storageExtend(c);
            return;
        }
        this.resizeCheck();
        int L = this.storage.length;
        int f = this.offset;
        int s2 = a + e + b;
        int L2 = this.recLength(s2);
        if (L2 == L) {
            if (a <= b) {
                int f2 = f - c;
                if (f2 >= 0) {
                    if (a > 0) {
                        System.arraycopy(this.storage, f, this.storage, f2, a);
                    }
                    this.offset = f2;
                    this.size = s2;
                } else {
                    this.newStorageAvoided(a, d, b, e);
                }
            } else {
                int g2 = f + a + e;
                if (g2 + b <= L) {
                    if (b > 0) {
                        System.arraycopy(this.storage, g2 - c, this.storage, g2, b);
                    }
                    this.size = s2;
                } else {
                    this.newStorageAvoided(a, d, b, e);
                }
            }
        } else if (L2 > 0) {
            this.newStorage(L2, a, d, b, e);
        } else {
            this.setStorage(emptyStorage);
        }
    }

    private void newStorageAvoided(int a, int d, int b, int e) {
        int f2;
        int f = this.offset;
        int g = f + a + d;
        int s2 = a + e + b;
        if (a == b) {
            f2 = (this.storage.length - s2) / 2;
        } else {
            long spare = this.storage.length - s2;
            f2 = (int)(spare * (long)b / (long)(a + b));
        }
        int n = f2 + a + e;
        if (f2 + a > g) {
            if (b > 0) {
                System.arraycopy(this.storage, g, this.storage, n, b);
            }
            if (a > 0) {
                System.arraycopy(this.storage, f, this.storage, f2, a);
            }
        } else {
            if (a > 0) {
                System.arraycopy(this.storage, f, this.storage, f2, a);
            }
            if (b > 0) {
                System.arraycopy(this.storage, g, this.storage, n, b);
            }
        }
        this.size = s2;
        this.offset = f2;
    }

    private void newStorage(int L2, int a, int d, int b, int e) {
        int f2;
        int f = this.offset;
        int g = f + a + d;
        int s2 = a + e + b;
        byte[] newStorage = new byte[L2];
        if (a == b) {
            f2 = (L2 - s2) / 2;
        } else {
            long spare = L2 - s2;
            f2 = (int)(spare * (long)b / (long)(a + b));
        }
        if (a > 0) {
            System.arraycopy(this.storage, f, newStorage, f2, a);
        }
        if (b > 0) {
            System.arraycopy(this.storage, g, newStorage, f2 + a + e, b);
        }
        this.setStorage(newStorage, s2, f2);
    }

    private void storageExtend(int e) {
        if (e == 0) {
            return;
        }
        this.resizeCheck();
        int L = this.storage.length;
        int f = this.offset;
        int s2 = this.size + e;
        int L2 = this.recLength(s2);
        if (L2 <= L) {
            int g2 = f + s2;
            if (g2 > L) {
                if (this.size > 0) {
                    System.arraycopy(this.storage, this.offset, this.storage, 0, this.size);
                }
                this.offset = 0;
            }
            this.size = s2;
        } else {
            byte[] newStorage = new byte[L2];
            if (this.size > 0) {
                System.arraycopy(this.storage, f, newStorage, 0, this.size);
            }
            this.setStorage(newStorage, s2);
        }
    }

    private void storageDelete(int a, int d) {
        if (d == 0) {
            return;
        }
        this.resizeCheck();
        int L = this.storage.length;
        int f = this.offset;
        int b = this.size - (a + d);
        int s2 = a + b;
        int L2 = this.recLength(s2);
        if (L2 == L) {
            if (a <= b) {
                int f2 = f + d;
                if (a > 0) {
                    System.arraycopy(this.storage, f, this.storage, f2, a);
                }
                this.offset = f2;
                this.size = s2;
            } else {
                int g2 = f + a;
                if (b > 0) {
                    System.arraycopy(this.storage, g2 + d, this.storage, g2, b);
                }
                this.size = s2;
            }
        } else if (L2 > 0) {
            int g = f + a + d;
            int f2 = (L2 - s2) / 2;
            byte[] newStorage = new byte[L2];
            if (a > 0) {
                System.arraycopy(this.storage, f, newStorage, f2, a);
            }
            if (b > 0) {
                System.arraycopy(this.storage, g, newStorage, f2 + a, b);
            }
            this.setStorage(newStorage, s2, f2);
        } else {
            this.setStorage(emptyStorage);
        }
    }

    private void storageDeleteEx(int a, int c, int d) {
    }

    static {
        PyType.addBuilder(PyByteArray.class, new PyByteArray$PyExposer());
        TYPE = PyType.fromClass(PyByteArray.class);
    }
}

