(function() {
    'use strict';

    dashboard.videoService = dashboard.videoService || {};

    dashboard.videoService.searchVideos = function(searchKeywords) {
        return $.Deferred(function(deferred) {
            var searches = dashboard.videoService.mockData.searches;
            for (var i = 0; i < searches.length; i++) {
                if (searches[i].keywords === searchKeywords) {
                    // zwracanie pierwszych dopasowanych wyników wyszukiwania 
                    deferred.resolve(searches[i].data);
                    return;
                }
            }
            deferred.reject('Nie znaleziono!');
        }).promise();
    };

    dashboard.videoService.getVideo = function(videoTitle) {
        return $.Deferred(function(deferred) {
            var videos = dashboard.videoService.mockData.allVideos;
            for (var i = 0; i < videos.length; i++) {
                if (videos[i].snippet.title === videoTitle) {
                    // zwracanie pierwszego dopasowanego elementu
                    deferred.resolve(videos[i]);
                    return;
                }
            }
            deferred.reject('Nie znaleziono!');
        }).promise();
    };

    var videoBaseUrl = 'https://www.youtube.com/watch?v=';
    dashboard.videoService.getVideoUrl = function(videoId) {
        return videoBaseUrl + videoId;
    };

})();
