/*!
 * jQuery lightweight plugin boilerplate
 * Original author: @ajpiano
 * Further changes, comments: @addyosmani
 * Licensed under the MIT license
 */
;(function ( $, window, document, undefined ) {
	var pluginName = "defaultPluginName",
		defaults = {
			propertyName: "value"
		};

	function Plugin( element, options ) {
		this.element = element;
		this.options = $.extend( {}, defaults, options) ;
		this._defaults = defaults;
		this._name = pluginName;

		this.init();
	}

	Plugin.prototype = {

		init: function() {
			// Place initialization logic here
		},

		yourOtherFunction: function(options) {
			// some logic
		},

		_priv: function(options) {
			console.log("private");
		}
	};

	// A really lightweight plugin wrapper around the constructor,
	// preventing against multiple instantiations
	$.fn[pluginName] = function ( options ) {
		var restArgs = Array.prototype.slice.call(arguments, 1);
		return this.each(function () {
			var instance = $.data(this, "plugin_" + pluginName);
			if (!instance) {
				instance = new Plugin( this, options );
				$.data(this, "plugin_" + pluginName, instance);
			} else if (typeof options === "string" && // method name
				options[0] !== "_" && // protect private methods
				typeof instance[options] === "function") {
				instance[options].apply(instance, restArgs);
			}
		});
	};

})( jQuery, window, document );
