(function() {
    'use strict';

    dashboard.counter = dashboard.counter || {};

    var dashboardItemCounter;
    var $counter;

    dashboard.counter.init = function() {
        $counter = $('#dashboardItemCounter');
        
        var $boxContainer = dashboard.$container.find('.boxContainer');
        var initialCount = $boxContainer.find('.boxsizer').length;
        dashboard.counter.setValue(initialCount);

        dashboard.$container.find('.dashboardCategories').on('click', 'button', function() {
            dashboard.counter.setValue(dashboardItemCounter + 1);
        });

        $boxContainer.on('click', '.boxCloseButton', function() {
            dashboard.counter.setValue(dashboardItemCounter - 1);
        });
    };

    dashboard.counter.setValue = function (value) {
        dashboardItemCounter = value;
        $counter.text(dashboardItemCounter);
    };

})();
