(function() {
    'use strict';

    dashboard.videoService = dashboard.videoService || {};

    var key = 'AIzaSyCPo42prVqGaPMbEiwKHDaMMRzc-YW2Yio';
    var baseSearchUrl = 'https://www.googleapis.com/youtube/v3/search';
    var videoBaseUrl = 'https://www.youtube.com/watch?v=';

    dashboard.videoService.searchVideos = function(searchKeywords) {
        return $.getJSON(baseSearchUrl, {
            key: key,
            type: 'video',
            videoEmbeddable: true,
            part: 'snippet',
            maxResults: 4,
            q: searchKeywords
        });
    };

    dashboard.videoService.getVideo = function(videoTitle) {
        return $.getJSON(baseSearchUrl, {
            key: key,
            type: 'video',
            videoEmbeddable: true,
            part: 'snippet',
            maxResults: 1,
            q: videoTitle
        }).then(function(results) {
            return results.items[0];
        });
    };

    dashboard.videoService.getVideoUrl = function(videoId) {
        return videoBaseUrl + videoId;
    };

})();
