// define a slightly different shake effect
// by passing different options
// $('div').vibrate({loops: 5});

(function($) {
	var defaultOptions = {
		loops: 2,
		amplitude: 8,
		period: 100,
		direction: 'left'
	};

	$.fn.vibrate = function(options) {
		options = $.extend({}, defaultOptions, options);

		this.each(function(i, element) {
			var $element = $(element);
			if ($element.css('position') === 'static') {
				$element.css({ position: 'relative' });
			}
		});

		for (var i = 0, len = options.loops * 4; i < len; i++) {
			var animationProperties = {};
			var movement = (i % 2) ?
				'+=':
				'-=';

			movement += (i === 0 || i === len - 1) ?
				options.amplitude / 2:
				options.amplitude;

			var t = (i === 0 || i === len - 1) ?
				options.period / 4:
				options.period / 2;

			animationProperties[options.direction] = movement;
			this.animate(animationProperties, t);
		}

		return this;
	};
})(jQuery);
