jQuery.Event = function( src, props ) {

	// Umożliwia tworzenie instancji bez słowa kluczowego new
	if ( !( this instanceof jQuery.Event ) ) {
		return new jQuery.Event( src, props );
	}

	// Obiekt zdarzenia
	if ( src && src.type ) {
		this.originalEvent = src;
		this.type = src.type;

		// Zdarzenia propagowane w górę drzewa dokumentu mogły zostać oznaczone
		// jako zablokowane przez procedurę obsługi niżej w drzewie; należy uwzględnić odpowiednią wartość.
		this.isDefaultPrevented = src.defaultPrevented ||
				src.defaultPrevented === undefined &&

				// Obsługa: Android<4.0
				src.returnValue === false ?
			returnTrue :
			returnFalse;

	// Typ zdarzenia
	} else {
		this.type = src;
	}

	// Umieszczenie w obiekcie zdarzenia jawnie podanych właściwości
	if ( props ) {
		jQuery.extend( this, props );
	}

	// Utworzenie znacznika czasu, jeśli nie ma go pojawiające się zdarzenie
	this.timeStamp = src && src.timeStamp || jQuery.now();

	// Oznaczenie jako ustalonego
	this[ jQuery.expando ] = true;
};
