// jQuery 2.2.0
jQuery.ajaxSettings.xhr = function() {
	try {
		return new window.XMLHttpRequest();
	} catch ( e ) {}
};

// 1.12.0
// Tworzenie obiektu żądania
// (nadal dołączane do ajaxSettings w celu zapewnienia zgodności wstecz)
jQuery.ajaxSettings.xhr = window.ActiveXObject !== undefined ?

	// Obsługa: IE6-IE8
	function() {

		// Obiekt XHR nie może uzyskać dostępu do plików lokalnych; w tym celu zawsze należy używać ActiveX
		if ( this.isLocal ) {
			return createActiveXHR();
		}

		// Obsługa: IE 9-11
		// Gdy używany jest obiekt ActiveX XHR, program IE wydaje się generować
		// błąd w wypadku międzydomenowych żądań PATCH. W przypadku programu IE w
		// wersji 9 lub nowszej zawsze należy używać macierzystego obiektu XHR.
		// Uwaga: warunek ten nie dotyczyc przeglądarki Edge, ponieważ nie definiuje ona
		// document.documentMode, ale też nie obsługuje ActiveX. Z tego powodu przeglądarka
		// ta nie uzyska dostępu do tego kodu.
		if ( document.documentMode > 8 ) {
			return createStandardXHR();
		}

		// Obsługa: IE<9
		// Stary obiekt XHR programu IE nie obsługuje metod innych niż zgodne z RFC2616
		// Więcej informacji pod adresami http://msdn.microsoft.com/en-us/library/ie/ms536648(v=vs.85).aspx i
		// http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9
		// Sprawdzenie dotyczy sześciu, a nie ośmiu metod, ponieważ
		// program IE nie obsługuje też metod trace i connect
		return /^(get|post|head|put|delete|options)$/i.test( this.type ) &&
			createStandardXHR() || createActiveXHR();
	} :

	// W przypadku wszystkich innych przeglądarek należy użyć standardowego obiektu XMLHttpRequest
	createStandardXHR;

// Funkcje tworzące xhrs
function createStandardXHR() {
	try {
		return new window.XMLHttpRequest();
	} catch ( e ) {}
}

function createActiveXHR() {
	try {
		return new window.ActiveXObject( "Microsoft.XMLHTTP" );
	} catch ( e ) {}
}
