(function() {
	'use strict';

	window.dataDrivenQuiz = window.dataDrivenQuiz || {};

	function MultipleChoiceBuilder() {
		this.title = 'Bez tytułu';
		this.options = [];
	}
	dataDrivenQuiz.MultipleChoiceBuilder = MultipleChoiceBuilder;

	MultipleChoiceBuilder.prototype.setTitle = function(title) {
		this.title = title;
		return this;
	};

	MultipleChoiceBuilder.prototype.setAcceptsMultiple = function(acceptsMultiple) {
		this.acceptsMultiple = acceptsMultiple;
		return this;
	};

	MultipleChoiceBuilder.prototype.addOption = function(title) {
		this.options.push(title);
		return this;
	};

	MultipleChoiceBuilder.prototype.getResult = function() {
		var $header = $('<header>').text(this.title || 'Bez tytułu');

		var questionGuid = 'quizQuestion' + (jQuery.guid++);
		var $optionsList = $('<ul class="unstyled">');
		for (var i = 0; i < this.options.length; i++) {
			var $input = $('<input />').attr({
				'type': this.acceptsMultiple ? 'checkbox' : 'radio',
				'value': i,
				'name': questionGuid,
			});
			
			var $option = $('<li>');
			$('<label>').append($input, $('<span>').text(this.options[i]))
				.appendTo($option);
			$optionsList.append($option);
		}
		return $('<article>').append($header, $optionsList);
	};

	dataDrivenQuiz.init = function() {
		for (var i = 0; i < dataDrivenQuiz.questions.length; i++) {
			var question = dataDrivenQuiz.questions[i];
			var builder = new dataDrivenQuiz.MultipleChoiceBuilder();

			builder.setTitle(question.title)
				.setAcceptsMultiple(question.acceptsMultiple);

			for (var j = 0; j < question.options.length; j++) {
				builder.addOption(question.options[j]);
			}

			var quizElement = builder.getResult();
			$('form').append(quizElement);
		}
	};

	$(document).ready(dataDrivenQuiz.init);

	dataDrivenQuiz.questions = [{
		title: 'Jaki jest Twój preferowany sposób pisania kodu JavaScript?',
		options: [
		  'umieszczanie w kodzie HTML', 
      'wewnątrz plików *.js', 
      'w niewielkich modułach po jednym w pliku *.js'
		]
	}, {
		title: 'Co zwraca funkcja $() wywołana z selektorem CSS?',
		options: [
			'pojedynczy element', 
      'tablica elementów', 
      'kod HTML wybranego elementu', 
      'obiekt złożony'
		]
	}, {
		title: 'Które z poniższych to wzorce projektowe?',
		acceptsMultiple: true,
		options: [
			'proces czyszczący pamięć', 
      'klasa', 
      'literał obiektu', 
      'obserwator'
		]
	}, {
		title: 'Jak uzyskać dostęp do elementu <body> strony?',
		acceptsMultiple: true,
		options: [
			'document.body',
			'document.getElementsByTagName(\'body\')[0]',
			'$(\'body\')[0]',
			'document.querySelector(\'body\')'
		]
	}];

})();
