from bitcoin.rpc import RawProxy

p = RawProxy()

# Wysokość bloku, w którym zarejestrowana została transakcja Alice
blockheight = 277316

# Pobieranie skrótu bloku z wysokości 277316
blockhash = p.getblockhash(blockheight)

# Pobieranie bloku na podstawie skrótu
block = p.getblock(blockhash)

# Pole tx zawiera listę identyfikatorów wszystkich transakcji z bloku
transactions = block['tx']

block_value = 0

# Przetwarzanie wszystkich identyfikatorów transakcji z bloku
for txid in transactions:
    tx_value = 0
	# Pobieranie nieprzetworzonej transakcji na podstawie identyfikatora
    raw_tx = p.getrawtransaction(txid)
	# Dekodowanie transakcji
    decoded_tx = p.decoderawtransaction(raw_tx)
	# Przetwarzanie wszystkich wyjść z transakcji
    for output in decoded_tx['vout']:
		# Dodawanie wartości wszystkich wyjść
        tx_value = tx_value + output['value']
        
	# Dodawanie wartości danej transakcji do sumy
    block_value = block_value + tx_value

print("Łączna wartość transakcji z bloku: ", block_value)