#include <bitcoin/bitcoin.hpp>

bc::hash_digest create_merkle(bc::hash_list& merkle)
{
    // Kończenie pracy, jeśli lista skrótów jest pusta.
    if (merkle.empty())
        return bc::null_hash;
    else if (merkle.size() == 1)
        return merkle[0];

    // Dopóki na liście występuje więcej niż jeden skrót, należy wykonywać pętlę.
    while (merkle.size() > 1)
    {
        // Jeśli liczba skrótów jest nieparzysta, należy powielić ostatni skrót z listy.
        if (merkle.size() % 2 != 0)
            merkle.push_back(merkle.back());
        // Teraz lista obejmuje parzystą liczbę elementów.
        assert(merkle.size() % 2 == 0);

        // Nowa lista skrótów.
        bc::hash_list new_merkle;
        // Przetwarzanie skrótów w pętli po dwa.
        for (auto it = merkle.begin(); it != merkle.end(); it += 2)
        {
            // Złączanie obu aktualnych skrótów.
            bc::data_chunk concat_data(bc::hash_size * 2);
            auto concat = bc::make_serializer(concat_data.begin());
            concat.write_hash(*it);
            concat.write_hash(*(it + 1));
            assert(concat.iterator() == concat_data.end());
            // Haszowanie obu skrótów.
            bc::hash_digest new_root = bc::bitcoin_hash(concat_data);
            // Dodawanie wyniku do nowej listy.
            new_merkle.push_back(new_root);
        }
        // Nowa lista.
        merkle = new_merkle;

        // Dane diagnostyczne -------------------------------
        std::cout << "Aktualna zawartość drzewa skrótów:" << std::endl;
        for (const auto& hash: merkle)
            std::cout << "  " << bc::encode_hex(hash) << std::endl;
        std::cout << std::endl;
        // --------------------------------------------------
    }
    // Ostatecznie zostaje jeden element.
    return merkle[0];
}

int main()
{
    // Zastępowanie skrótów tymi z bloku, aby odtworzyć korzeń drzewa skrótów.
    bc::hash_list tx_hashes{{
        bc::hash_literal("0000000000000000000000000000000000000000000000000000000000000000"),
        bc::hash_literal("0000000000000000000000000000000000000000000000000000000000000011"),
        bc::hash_literal("0000000000000000000000000000000000000000000000000000000000000022"),
    }};
    const bc::hash_digest merkle_root = create_merkle(tx_hashes);
    std::cout << "Wynik: " << bc::encode_hex(merkle_root) << std::endl;
    return 0;
}

