# Wybieranie wyjść z UTXO za pomocą algorytmu zachłannego

from sys import argv

class OutputInfo:

    def __init__(self, tx_hash, tx_index, value):
        self.tx_hash = tx_hash
        self.tx_index = tx_index
        self.value = value

    def __repr__(self):
        return "<%s:%s z %s Satoshi>" % (self.tx_hash, self.tx_index,
                                             self.value)

# Wybiera optymalne wyjścia z listy niewydanych wyjść.
# Zwraca listę wyjść i resztę przesyłaną na adres reszty.
def select_outputs_greedy(unspent, min_value):
    # Jeśli konto jest puste, kod kończy pracę.
    if not unspent:
        return None
    # Podział na dwie listy.
    lessers = [utxo for utxo in unspent if utxo.value < min_value]
    greaters = [utxo for utxo in unspent if utxo.value >= min_value]
    key_func = lambda utxo: utxo.value
    if greaters:
        # Niepusta. Znajdowanie najmniejszego większego wyjścia.
        min_greater = min(greaters, key=key_func)
        change = min_greater.value - min_value
        return [min_greater], "Reszta: %d Satoshi" % change
	# Nie znaleziono odpowiedniej wartości na liście greaters.
	# Zamiast tego kod próbuje dobrać kilka wartości z listy lessers.
	# Wartości są porządkowane od największej do najmniejszej. Celem jest 
	# użycie jak najmniejszej liczby wejść.
    lessers.sort(key=key_func, reverse=True)
    result = []
    accum = 0
    for utxo in lessers:
        result.append(utxo)
        accum += utxo.value
        if accum >= min_value:
            change = accum - min_value
            return result, "Reszta: %d Satoshi" % change
    # Nie znaleziono wyników.
    return None, 0

def main():
    unspent = [
        OutputInfo("ebadfaa92f1fd29e2fe296eda702c48bd11ffd52313e986e99ddad9084062167", 1,  8000000),
        OutputInfo("6596fd070679de96e405d52b51b8e1d644029108ec4cbfe451454486796a1ecf", 0,  16050000),
        OutputInfo("b2affea89ff82557c60d635a2a3137b8f88f12ecec85082f7d0a1f82ee203ac4", 0,  10000000),
        OutputInfo("7dbc497969c7475e45d952c4a872e213fb15d45e5cd3473c386a71a1b0c136a1", 0,  25000000),
        OutputInfo("55ea01bd7e9afd3d3ab9790199e777d62a0709cf0725e80a7350fdb22d7b8ec6", 17,  5470541),
        OutputInfo("12b6a7934c1df821945ee9ee3b3326d07ca7a65fd6416ea44ce8c3db0c078c64", 0,  10000000),
        OutputInfo("7f42eda67921ee92eae5f79bd37c68c9cb859b899ce70dba68c48338857b7818", 0,  16100000),
    ]
    
    if len(argv) > 1: 
        target = long(argv[1])
    else:
        target = 55000000
        
    print "Na potrzeby transakcji o wartości %d Satoshi (%f bitcoinów) zastosuj: " % (target, target/10.0**8)
    print select_outputs_greedy(unspent, target)

if __name__ == "__main__":
    main()

