/*
  Wyświetlanie wiadomości od Satoshiego z pierwszego bloku
*/
#include <iostream>
#include <bitcoin/bitcoin.hpp>

int main()
{
    // Wczytywanie pierwszego bloku
    const bc::block_type block = bc::genesis_block();
    // Blok początkowy obejmuje jedną transakcję coinbase
    assert(block.transactions.size() == 1);
    // Pobieranie pierwszej transakcji z bloku (jest to transakcja coinbase)
    const bc::transaction_type& coinbase_tx = block.transactions[0];
    // Transakcja coinbase obejmuje jedno wejście
    assert(coinbase_tx.inputs.size() == 1);
    const bc::transaction_input_type& coinbase_input = coinbase_tx.inputs[0];
    // Przekształcanie skryptu z wejścia na dane surowe
    const bc::data_chunk raw_message = save_script(coinbase_input.script);
    // Przekształcanie na typ std::string
    std::string message;
    message.resize(raw_message.size());
    std::copy(raw_message.begin(), raw_message.end(), message.begin());
    // Wyświetlanie komunikatu z pierwszego bloku
    std::cout << message << std::endl;
    return 0;
}
