import socket
import os

# Host do nasłuchiwania
HOST = '192.168.1.206'

def main():
    # Utworzenie surowego gniazda i powiązanie go z interfejsem publicznym
    if os.name == 'nt':
        socket_protocol = socket.IPPROTO_IP
    else:
        socket_protocol = socket.IPPROTO_ICMP

    sniffer = socket.socket(socket.AF_INET, socket.SOCK_RAW, socket_protocol)
    sniffer.bind((HOST, 0))
    # Przechwytujemy też nagłówki IP
    sniffer.setsockopt(socket.IPPROTO_IP, socket.IP_HDRINCL, 1)

    if os.name == 'nt':
        sniffer.ioctl(socket.SIO_RCVALL, socket.RCVALL_ON)

    # Wczytanie pojedynczego pakietu
    print(sniffer.recvfrom(65565))

    # Jeśli używany jest system Windows, włączamy tryb nieograniczony
    if os.name == 'nt':
        sniffer.ioctl(socket.SIO_RCVALL, socket.RCVALL_OFF)

if __name__ == '__main__':
    main()