#!/usr/bin/env python3
import nmap
import argparse

def callbackResult(host, scan_result):
    port_state = scan_result['scan'][host]['tcp']
    print("Polecenie: " + scan_result['nmap']['command_line'])
    for key, value in port_state.items():
        print('Port {0} --> {1}'.format(key, value))

class NmapScannerAsync:
    def __init__(self):
        self.portScannerAsync = nmap.PortScannerAsync()
    
    def scanning(self):
        while self.portScannerAsync.still_scanning():
            print("Skanowanie >>>")
            self.portScannerAsync.wait(5)

    def nmapScanAsync(self, hostname, port):
        try:
            print("Skanowanie portu " + port + " ..........")
            self.portScannerAsync.scan(hostname, arguments = "-A -sV -p" + port, callback = callbackResult)
            self.scanning()
        except Exception as exception:
            print("Błąd połączenia z hostem " + hostname, str(exception))

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description = 'Asynchroniczny skaner portów')
    parser.add_argument("--host", dest = "host", help = "nazwa lub adres hosta", required = True)
    parser.add_argument("-ports", dest = "ports", help = "lista portów oddzielonych przecinkami (domyślnie 80,8080)", default = "80,8080")
    parsed_args = parser.parse_args()
    port_list = parsed_args.ports.split(',')
    host = parsed_args.host
    for port in port_list:
        NmapScannerAsync().nmapScanAsync(host, port)