#!usr/bin/env python3
import sqlite3
import os

def getDownloads(downloadDB):
    try:
        connection = sqlite3.connect(downloadDB)
        cursor = connection.cursor()
        cursor.execute('SELECT name, source, datetime(endTime/1000000,\'unixepoch\') FROM moz_downloads;')
        print('\n[*] --- Pobrane pliki --- ')
        for row in cursor:
            print('[+] Plik: ' + str(row[0]) + ', strona: ' + str(row[1]) + ', data: ' + str(row[2]))
    except Exception as exception:
        print('\n[*] Błąd odczytu tabeli moz_downloads', exception)

def getCookies(cookiesDB):
    try:
        connection = sqlite3.connect(cookiesDB)
        cursor = connection.cursor()
        cursor.execute('SELECT host, name, value FROM moz_cookies')
        print('\n[*] -- Ciastka --')
        for row in cursor:
            print('[+] Strona: ' + str(row[0]) + ', ciastko: ' + str(row[1]) + ', zawartość: ' + str(row[2]))
    except Exception as exception:
        print('\n[*] Błąd odczytu tabeli moz_cookies', exception)

def getHistory(placesDB):
    try:
        connection = sqlite3.connect(placesDB)
        cursor = connection.cursor()
        cursor.execute("SELECT url, datetime(visit_date/1000000, 'unixepoch') FROM moz_places, moz_historyvisits WHERE visit_count > 0 AND moz_places.id == moz_historyvisits.place_id;")
        print('\n[*] -- Historia --')
        for row in cursor:
            print('[+] Strona: ' + str(row[0]) + ', data: ' + str(row[1]))
    except Exception as exception:
            print('\n[*] Błąd odczytu tabel moz_places i moz_historyvisits', exception)

def main():
    if os.path.isfile('downloads.sqlite'):
        getDownloads('downloads.sqlite')
    else:
        print('[!] Brak pliku downloads.sqlite')
    if os.path.isfile('cookies.sqlite'):
        getCookies('cookies.sqlite')
    else:
        print('[!] Brak pliku cookies.sqlite')
    if os.path.isfile('places.sqlite'):
        getHistory('places.sqlite')
    else:
        print('[!] Brak pliku places.sqlite')

if __name__ == '__main__':
    main()