#!/usr/bin/env python3
import getpass
import paramiko

def run_ssh_cmd(username, password, command, hostname, port):
    ssh_client = paramiko.SSHClient()
    ssh_client.set_missing_host_key_policy(paramiko.AutoAddPolicy())
    ssh_client.load_system_host_keys()
    ssh_client.connect(hostname, port, username, password)
    stdin, stdout, stderr = ssh_client.exec_command(command)
    stdin.close()
    for line in stdout.read().splitlines():
        print(line.decode())

if __name__ == '__main__':
    hostname = input("Podaj adres serwera: ")
    port = input("Podaj numer portu: ")
    username = input("Podaj nazwę użytkownika: ")
    password = getpass.getpass(prompt = "Podaj hasło: ")
    command = input("Podaj polecenie: ")
    run_ssh_cmd(username, password, command, hostname, port)